/*******************************************************************************
* Copyright (c) 2004 Actuate Corporation.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*  Actuate Corporation  - initial API and implementation
*******************************************************************************/ 


package org.eclipse.birt.report.tests.model.api;

import java.util.Locale;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.tests.model.BaseTestCase;

import com.ibm.icu.util.ULocale;


/**
 * Test case for LabelHandle.
 * 
 */

public class LabelHandleTest extends BaseTestCase
{

    /**
	 * @param name
	 */
	public LabelHandleTest(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}

	/**
     *  Input design file.
     */
    
    private final static String INPUT_FILE = "LabelHandleTest.xml"; //$NON-NLS-1$

	public static Test suite(){
		return new TestSuite(LabelHandleTest.class);
		
		
		
	}
    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    
    protected void setUp( ) throws Exception
    {
    	super.setUp( );
        openDesign( INPUT_FILE );
    }
    
    /**
     * Test getDisplayText().
     */
    
	public void testGetDisplayText()
    {
		LabelHandle label1 = (LabelHandle)designHandle.findElement( "label1" ); //$NON-NLS-1$
        ThreadResources.setLocale( ULocale.US );
        assertEquals( "en_US", label1.getDisplayText() ); //$NON-NLS-1$
        
        ThreadResources.setLocale( new ULocale( "en" ) ); //$NON-NLS-1$
        assertEquals( "en", label1.getDisplayText() ); //$NON-NLS-1$

        LabelHandle label2 = (LabelHandle)designHandle.findElement( "label2" ); //$NON-NLS-1$
        assertEquals( "label2", label2.getDisplayText() ); //$NON-NLS-1$
        
        LabelHandle label3 = (LabelHandle)designHandle.findElement( "label3" ); //$NON-NLS-1$
        assertEquals( "label3", label3.getDisplayText() ); //$NON-NLS-1$
        
        LabelHandle label4 = (LabelHandle)designHandle.findElement( "label4" ); //$NON-NLS-1$
        ThreadResources.setLocale( ULocale.US );
        assertEquals( "label4", label4.getDisplayText() ); //$NON-NLS-1$
        
    }
}
