package org.eclipse.birt.report.tests.model.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class OpenLibraryTest extends BaseTestCase
{
	String fileName = "BlankLibrary.xml";
	
	public OpenLibraryTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(OpenLibraryTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testOpenLibrary1( ) throws Exception
	{

		
		File file = new File( getClassFolder( ) + INPUT_FOLDER + fileName );
		
		InputStream is = new FileInputStream( file );
		assertTrue( is != null );
		
		openLibrary( file.toURL() , is );
		
	}
	public void testOpenLibrary2( ) throws Exception
	{
		
		File file = new File( getClassFolder( ) + INPUT_FOLDER + fileName );
		
		InputStream is = new FileInputStream( file );
		assertTrue( is != null );
		
		openLibrary( null , is );
		
	}
	public void testOpenLibrary3( ) throws Exception
	{
		
		File file = new File( getClassFolder( ) + INPUT_FOLDER + fileName );
		
		InputStream is = new FileInputStream( file );
		assertTrue( is != null );
		
		File file2 = new File ( getClassFolder( ) + INPUT_FOLDER );
		
		openLibrary( file2.toURL() , is );
		
	}
	public void testOpenLibrary4( ) throws Exception
	{
		
		File file = new File( getClassFolder( ) + INPUT_FOLDER + fileName );
		
		InputStream is = new FileInputStream( file );
		assertTrue( is != null );
		
		File file2 = new File ( getClassFolder( ) + OUTPUT_FOLDER );
		
		openLibrary( file2.toURL() , is );
		
	}
}
