/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.regression;

import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.elements.DesignChoiceConstants;
import org.eclipse.birt.report.tests.model.BaseTestCase;

/**
 * Regression description:
 * </p>
 * It's a backward compatibility bug. Unsupport old format property.
 * </p>
 * Test description:
 * <p>
 * Parser the design file, get category and pattern correctly.
 * </p>
 */

public class Ref_134213 extends BaseTestCase
{
	public final static String INPUT = "Reg_134213.xml"; 

	public void test( ) throws DesignFileException
	{
        openDesign( INPUT );
        ScalarParameterHandle param1 = (ScalarParameterHandle)designHandle.getParameters( ).get( 0 );
        ScalarParameterHandle param2 = (ScalarParameterHandle)designHandle.getParameters( ).get( 1 );
        ScalarParameterHandle param3 = (ScalarParameterHandle)designHandle.getParameters( ).get( 2 );
        ScalarParameterHandle param4 = (ScalarParameterHandle)designHandle.getParameters( ).get( 3 );
        
        assertEquals("##,###.##",param1.getPattern( ));
        assertEquals(DesignChoiceConstants.STRING_FORMAT_TYPE_CUSTOM,param2.getCategory( ));
        assertEquals("@@.@@",param2.getPattern( ));
        assertEquals(DesignChoiceConstants.NUMBER_FORMAT_TYPE_CURRENCY,param3.getCategory( ));
        assertEquals("abc:##:00",param4.getPattern( ));
	}
}
