/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.regression;

import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.tests.model.BaseTestCase;

/**
 * Regression description:
 * </p>
 * Change predefine style "table" to "list", no effect
 * </p>
 * Test description:
 * <p>
 * check if the style "list" will apply to the list automatically
 * </p>
 */

public class Reg_128356 extends BaseTestCase
{

	public final static String INPUT = "Reg_128356.xml";

	public Reg_128356( String name )
	{
		super( name );
		// TODO Auto-generated constructor stub
	}

	public void test( ) throws DesignFileException, NameException
	{
		openDesign( INPUT );
		TableHandle table = (TableHandle) designHandle.findElement( "table" );
		ListHandle list = (ListHandle) designHandle.findElement( "list" );
		SharedStyleHandle style = designHandle.findStyle( "table" );

		assertEquals( "#0000FF", table
				.getStringProperty( Style.BACKGROUND_COLOR_PROP ) );

		style.setName( "list" );
		assertNull( table.getStringProperty( Style.BACKGROUND_COLOR_PROP ) );
		assertEquals( "#0000FF", list
				.getStringProperty( Style.BACKGROUND_COLOR_PROP ) );
	}

}
