/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.regression;

import java.io.File;
import java.net.URL;

import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.tests.model.BaseTestCase;

import com.ibm.icu.util.ULocale;
/**
 * Regression description:
 * </p>
 * Extends lib.datasource and lib.dataset, lib.dataset can't be extended
 * </p>
 * Test description:
 * <p>
 * Extends lib.datasource and lib.dataset
 * </p>
 */ 

public class Reg_130271 extends BaseTestCase
{

	public final static String INPUT = "Reg_130271.xml";
	public final static String OUTPUT = "Reg_130271_out.xml";
	public final static String GOLDEN = "Reg_130271_golden.xml";

	public void test( ) throws Exception
	{
		openLibrary( INPUT );
		DataSourceHandle datasource = libraryHandle
				.findDataSource( "Data Source" );
		DataSetHandle dataset = libraryHandle.findDataSet( "Data Set" );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		
		String filename = getClassFolder( ) + INPUT_FOLDER + INPUT+"Reg_130217.rptdesign";
		
		designHandle.setFileName( filename );

		designHandle.includeLibrary( INPUT, "lib" );
		DataSourceHandle dsource = (DataSourceHandle) designHandle
				.getElementFactory( ).newElementFrom( datasource, "dsource" );
		DataSetHandle dset = (DataSetHandle) designHandle.getElementFactory( )
				.newElementFrom( dataset, "dset" );

		designHandle.getDataSources( ).add( dsource );
		designHandle.getDataSets( ).add( dset );

		saveAs( OUTPUT );
		assertTrue( super.compareTextFile( GOLDEN, OUTPUT ) );
	}
}
