/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.regression;

import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.tests.model.BaseTestCase;

/**
 * Regression description:
 * </p>
 * Add a group on a table, Set group header's background color, undo twice will
 * cause NPE
 * </p>
 * Test description:
 * <p>
 * undo twice, no error
 * </p>
 */

public class Reg_130278 extends BaseTestCase
{
	public final static String INPUT = "Reg_130278.xml";
	private ElementFactory factory = null;

	public void test( ) throws Exception
	{
        openDesign(INPUT);
        TableHandle table = (TableHandle) designHandle.findElement( "table" );
        
        factory = new ElementFactory(designHandle.getModule( ));
        TableGroupHandle group = factory.newTableGroup( );
        RowHandle header = factory.newTableRow( );
        group.getHeader( ).add( header );
        
        table.getGroups( ).add( group );
        header.setProperty( Style.BACKGROUND_COLOR_PROP, "red" );
        
        designHandle.getCommandStack( ).undo( );
        assertEquals( null, header.getStringProperty( Style.BACKGROUND_COLOR_PROP ) );
        
        designHandle.getCommandStack( ).undo( );
        
        assertEquals(0,table.getGroups( ).getCount( ));
	}

}
