/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.reportItem;

import java.util.Hashtable;

import org.eclipse.birt.report.model.api.DesignElementHandle;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportDesign;


public class TestElement extends DesignElement {
  
	private Hashtable properties = null;
    
	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.api.core.IDesignElement#getHandle(org.eclipse.birt.report.model.elements.ReportDesign)
	 */
	public TestElement(ReportDesign design){
	    properties = new Hashtable();   
	}
	
	public TestElement(Hashtable pro){
		this.properties = pro;
	}
	
	public DesignElementHandle getHandle(ReportDesign design) {
		// TODO Auto-generated method stub
		return new TestElementHandle(design, this);
	}
	

	
	public Object clone(){
		
		Hashtable prop = (Hashtable)properties.clone(); 
		return new TestElement(prop);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.core.DesignElement#apply(org.eclipse.birt.report.model.elements.ElementVisitor)
	 */
	public void apply(ElementVisitor visitor) {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.core.DesignElement#getElementName()
	 */
	public String getElementName() {
		
		return "TestElement";
	}
	
	public Hashtable getAttributes(){
		return properties;
	}

	public DesignElementHandle getHandle(Module module) {
		// TODO Auto-generated method stub
		return null;
	}

}
