/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.reportItem;

import org.eclipse.birt.report.model.api.ReportItemHandle;

import org.eclipse.birt.report.model.api.ReportDesignHandle;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ReportDesign;

import java.util.Hashtable;


public  class TestElementHandle extends ReportItemHandle
{ 

     
   protected ReportDesign design = null;
   
   protected ReportDesignHandle designHandle = null;
   
   protected TestElement element = null;
   
   public TestElementHandle(ReportDesign design, DesignElement element){
   	  super(design, element);
   	  this.design = design;
   	  this.element = (TestElement)element; 
   }
   public Hashtable getAttributeValues(){
   	  return element.getAttributes();
   }
   
   public Object getAttribute(String name){
   	   return element.getAttributes().get(name);
   }
   
   public TestElement getReportItem(){
   	   return element;
   }
   
   
	
}
