/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.reportItem;

import java.util.Locale;

import com.ibm.icu.util.ULocale;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.ReportItemFactory;

public class TestReportItemFactoryImpl extends ReportItemFactory implements IMessages{

	
    public TestReportItemFactoryImpl()
    { 
    	super();
        
    }
	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.api.extension.IReportItemFactory#newReportItem(org.eclipse.birt.report.model.api.DesignElementHandle)
	 */
	public IReportItem newReportItem(DesignElementHandle extendedItemHandle) {

		return new TestReportItemImpl(extendedItemHandle);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.api.extension.IReportItemFactory#getMessages()
	 */
	public IMessages getMessages() {
		
		return this;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.api.extension.IMessages#getMessage(java.lang.String, java.util.Locale)
	 */
	public String getMessage(String key, ULocale locale) {
	
		final StringBuffer sb = new StringBuffer(key);
	    final int iFirstDot = sb.indexOf("."); //$NON-NLS-1$
	    if (iFirstDot == -1)
	        return key + "_value"; //$NON-NLS-1$
	    sb.delete(0, iFirstDot + 1);
	    int i = 0, iDot;
	    char c = sb.charAt(0);
	    sb.setCharAt(0, Character.toUpperCase(c));
	    do
	    {
	        iDot = sb.indexOf(".", i); //$NON-NLS-1$
	        if (iDot >= 0 && iDot < sb.length() - 1)
	        {
	            sb.setCharAt(iDot, ' ');
	            i = iDot + 1;
	        }
	    }
	    while (i < sb.length() && iDot != -1);
	    return sb.toString();
	    
	}
	public String getMessage(String key, Locale locale) {
		// TODO Auto-generated method stub
		return null;
	}
	
	

}
