/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.reportItem;


import java.io.ByteArrayInputStream;

import java.util.ArrayList;




import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.extension.ReportItem;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class TestReportItemImpl extends ReportItem {
	
	private transient DesignElementHandle handle = null;
	private static ArrayList liChoices = new ArrayList();
	private ArrayList liMembers = new ArrayList();
	private String XMLType = null;
	
	private TestElement element = null;
	
	static{
		
		
		
		liChoices.add(new TestChoiceDefinitionImpl("choices.test5.choice1",
				"choice1", "one"));
		liChoices.add(new TestChoiceDefinitionImpl("choices.test5.choice2",
				"choice2", "two"));
		liChoices.add(new TestChoiceDefinitionImpl("choices.test5.choice3",
				"choice3", "three"));        
        

	
	}
	
	
	
	public TestReportItemImpl(DesignElementHandle handle){
		
		this.handle = handle;
		if(element == null){
			
			element = new TestElement(handle.getDesign());
		}
		formModel();
	}
	
	public void setModel(TestElement model){
		
		this.element = model;
	}
	
	public TestElement getModel(){
		
		return element;
	}
	
    public IPropertyDefinition[] getPropertyDefinitions()
    {
    	TestPropertyDefinitionImpl defn = new TestPropertyDefinitionImpl("group1", "test6", "element.testingMatrix.test6",
        		false, PropertyType.STRING_TYPE, null, null, element==null?null:element.getAttributes().get("test6"));
    	liMembers.add(defn);
    	
    	
		defn = new TestPropertyDefinitionImpl("group1", "test7", "element.testingMatrix.test7",
        		false, PropertyType.INTEGER_TYPE, null, null, element==null?null:element.getAttributes().get("test7"));
        liMembers.add(defn);
        
        return new IPropertyDefinition[]
        {

        		 /**
        		 * String sGroupNameID, String sName,
			       String sDisplayNameID, boolean bList, int iType, List liChoices,
			       List liMembers, Object oDefaultValue)
        		 */
        	new TestPropertyDefinitionImpl(null, "test1", "element.testingMatrix.test1", false, 
                        PropertyType.STRING_TYPE, null, null, element==null?null:element.getAttributes().get("test1")),
            
		    new TestPropertyDefinitionImpl(null, "test2", "element.testingMatrix.test2", false, 
                        PropertyType.INTEGER_TYPE, null, null, element==null?null:element.getAttributes().get("test2")),
						
            new TestPropertyDefinitionImpl(null, "test3", "element.testingMatrix.test3", false, 
                                PropertyType.XML_TYPE, null, null,  element==null?null:element.getAttributes().get("test3")),
		   
            new TestPropertyDefinitionImpl(null, "test5", "element.testingMatrix.test5", false, 
                                PropertyType.CHOICE_TYPE, liChoices, null, element==null?null:element.getAttributes().get("test5")),
								
            new TestPropertyDefinitionImpl(null, "group1", "element.testingMatrix.test6",
                           		false, PropertyType.STRUCT_TYPE, null, liMembers, null)
		 };
		

            
    }
    
    public final Object getProperty(String propName)
    {
        
    	return element == null? null: element.getAttributes().get(propName);
    }
    
    
    public void deserialize(String propName, ByteArrayInputStream data) throws ExtendedElementException
    {
        
    	if(propName.equals("test3")){
    		byte[] bytes = new byte[100];
    		try{
    		data.read(bytes);
    	//	System.err.println("Test  "+new String(bytes));
    		XMLType = new String(bytes);
    		
    		}catch(Exception ex){
    			ex.printStackTrace();
    		}
    	}
    	
    	element.getAttributes().put("test3", XMLType);
    }
    
    
    /**
     * form the model from the retrieved extended elements 
     * 
     */
    private void formModel(){
    	
    	IPropertyDefinition[] defns = getPropertyDefinitions();
    	
        for(int i = 0; i < defns.length; i++){
        	TestPropertyDefinitionImpl defn = (TestPropertyDefinitionImpl)defns[i];
        	//System.out.println(defn.getName() + handle.getProperty(defn.getName()));
            try{
            	Object obj = handle.getProperty(defn.getName());
            	if( obj != null){
                if(defn.getType() == PropertyType.STRUCT_TYPE){
       
                	
                }else if(defn.getType() == PropertyType.CHOICE_TYPE){
                	
                	for(int j = 0; j < liChoices.size(); j++){
                		if(((TestChoiceDefinitionImpl)liChoices.get(j)).getName().equals(obj)){
                			element.getAttributes().put(defn.getName(),((TestChoiceDefinitionImpl)liChoices.
                					get(j)).getValue());
                			break;
                			
                		}
               
                	}
                	
                	
                	
                }else if(defn.getType() != PropertyType.XML_TYPE){
                	
                	element.getAttributes().put(defn.getName(), obj);
                }
            	}
            	
            }
        	catch (Exception ex){
        		ex.printStackTrace();
        	}
        	
        	
        	
        }
        
    
    }
	
}
