/*
 * Created on Jun 29, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.birt.report.tests.model.reportItem.test;

import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionLoader;
import org.eclipse.birt.report.tests.model.BaseTestCase;
import org.eclipse.birt.report.tests.model.reportItem.*;

import com.ibm.icu.util.ULocale;

/**
 * @author gxu
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ExtendedReportItemTest extends BaseTestCase {
    
    protected TestElementHandle testHandle = null;
    
    
    private static final String EXTENSION_NAME="item1";
    
	public ExtendedReportItemTest(String name){
    	super(name);
    }
    
	public static Test suite(){
		return new TestSuite(ExtendedReportItemTest.class);
	}
	

	public void setUp1() throws Exception{
		super.setUp();
		new PeerExtensionLoader( ).load( );
		ThreadResources.setLocale( ULocale.ENGLISH );
		List dd = MetaDataDictionary.getInstance().getExtensions();
	    for(int i=0; i < dd.size(); i++){
	    	
	    	IElementDefn defn = (IElementDefn)dd.get(i);

	    	
	    }
		
	}
    public void setUp() throws Exception{
    	super.setUp();
    	
    	new PeerExtensionLoader( ).load( );
		ThreadResources.setLocale( ULocale.ENGLISH);
		
    	openDesign( "ExtendedReportItemTest.xml" ); 
		assertNotNull( designHandle );
		
		DesignElementHandle handle = designHandle.findElement("test");	
		assertNotNull(handle);
		

		
		if(handle instanceof ExtendedItemHandle){
			
			/* get the handle of extended item*/
			ExtendedItemHandle extHandle = (ExtendedItemHandle)handle;
			IElementDefn defn = MetaDataDictionary.getInstance().getExtension(EXTENSION_NAME);
            
			assertNotNull("The extended report item cannot be loaded",defn);

			
	
			
			/*
			 * Test Name and Display name conformance
			 * */
			assertEquals("Extended Report Item Names Mismatch",defn.getName(),EXTENSION_NAME);
			//assertEquals("Extended Report Item Display Name Mismatch",
			//		defn.getDisplayName(), "report.item1");
			
			/*
			 * Load the element implementation
			 * */
			extHandle.loadExtendedElement();
			

			/* See if item is an instance of the extended report item*/
			IReportItem item = extHandle.getReportItem();
			assertTrue("Type Mismatch", item instanceof TestReportItemImpl);
			
			/* Get the handle of Test Element*/
			testHandle =(TestElementHandle)((TestReportItemImpl)item).getModel().getHandle(design);

			
		}else{
			testHandle = null;
			fail("Type Mismatch");
			
		}
		
    	
    }
    
    
    public void testNormalProperties(){
    	/*
    	 * test properties of Test1
    	 * */
    	Object value1 = testHandle.getAttribute("test1");
    	assertNotNull(value1);
    	assertTrue("Type Mismatch", value1 instanceof String);
    	assertEquals("Property Test1 is not correctly parsed", value1, "hello plugins");
    	
    	/*
    	 * test properties of Test2
    	 * 
    	 * */
    	Object value2 = testHandle.getAttribute("test2");
    	assertNotNull(value2);
    	assertTrue("Type Mismatch", value2 instanceof Integer);
    	assertEquals("Property Test2 is not correctly parsed", value2, new Integer(25));
    	
    	/**
    	 * test properties of Test3
    	 * XML Type
    	 * 
    	 */
    	Object value3 = testHandle.getAttribute("test3");
    	assertNotNull(value3);
    	String expectedXML = "<person category=\"student\">Harry</person>";
    	
    	assertEquals("Property Test3 is not correctly parsed", ((String)value3).trim(), expectedXML.trim());
    	
    	/**
    	 * Test properties of Test5 (Choices)
    	 */
    	Object value5 = testHandle.getAttribute("test5");
    	assertNotNull(value5);
    	String choice = "one";
    	assertEquals("Property test5 is not correctly parsed",value5, choice);
    }
    
    
   
    public void tearDown() throws Exception{
    	super.tearDown();
    }
    
    
}
