package org.eclipse.birt.report.tests.model.smoke;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class CascadingParameterGroupTest extends BaseTestCase
{

	public CascadingParameterGroupTest(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}

	 public static Test suite()
	    {
			
			return new TestSuite(CascadingParameterGroupTest.class);
		}
		protected void setUp( ) throws Exception
		{
			super.setUp( );
		}

		public void testGetPropertiesAndContents() throws DesignFileException
		{
			openDesign( "CascadingParameterGroupTest.xml" );
			CascadingParameterGroupHandle groupHandle = getGroupHandle( "Country-State-City" ); //$NON-NLS-1$
			assertEquals( "Group for Country-State-City", groupHandle.getDisplayName()); //$NON-NLS-1$
			
			SlotHandle parameters = groupHandle.getParameters();
			assertEquals( 3, parameters.getCount() );
			
			ScalarParameterHandle p1 = (ScalarParameterHandle) parameters.get( 0 );
			
			assertEquals( "dynamic", p1.getValueType() ); //$NON-NLS-1$
			assertEquals( "Country", p1.getName() ); //$NON-NLS-1$
			assertEquals( "ds1", p1.getDataSetName() ); //$NON-NLS-1$
			assertEquals( "row[\"country\"]", p1.getValueExpr() ); //$NON-NLS-1$
			assertEquals( "Enter country:", p1.getLabelExpr() ); //$NON-NLS-1$
			
		}
		
		private CascadingParameterGroupHandle getGroupHandle( String name )
		{
			SlotHandle parameters = this.designHandle.getParameters();
			for ( int i = 0; i < parameters.getCount(); i++ )
			{
				DesignElementHandle elementHandle = parameters.get( i );
				if( elementHandle.getName().equals( name ) )
					return (CascadingParameterGroupHandle)elementHandle;
			}
			
			return null;
		}
	
}
