package org.eclipse.birt.report.tests.model.smoke;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class DataElementHandleTest extends BaseTestCase
{
	String fileName = "BlankReport.xml";
	
	private String outFileName = "DataElementHandleDpt.xml"; 
	private String goldenFileName = "DataElementHandleDpt_golden.xml"; 
	
	
	
	public DataElementHandleTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(DataElementHandleTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testDataElement( ) throws Exception
	{
		openDesign( fileName );
		
//		New a data without name.
		DataItemHandle dataHandle = (DataItemHandle)designHandle.getElementFactory().newDataItem( "" );
		designHandle.getBody().add( dataHandle );
		
//		Set the data name
	    dataHandle.setName( "myData" );
	    assertEquals( "myData",  dataHandle.getName() );
	    
//	    Set the Expression value
//	    dataHandle.setValueExpr( "new Date()" );
//	    assertEquals( "new Date()" , dataHandle.getValueExpr() );
	    
//	    Set the data font family
	    dataHandle.setProperty( StyleHandle.FONT_FAMILY_PROP , "Sans Serif" );
	    assertEquals( "sans-serif" , dataHandle.getStringProperty( "fontFamily" ));
	    
//	    Set font weight
	    dataHandle.setProperty( StyleHandle.FONT_WEIGHT_PROP , "bold" );
	    assertEquals( "bold" , dataHandle.getStringProperty( "fontWeight" ) );
	    
//	    Set font style
	    dataHandle.setProperty( StyleHandle.FONT_STYLE_PROP , "italic" );
	    assertEquals( "italic" , dataHandle.getStringProperty( "fontStyle" ) );
	    

//	    Set the line for through
		dataHandle.setProperty( StyleHandle.TEXT_LINE_THROUGH_PROP , "line-through" );
		assertEquals( "line-through" , dataHandle.getStringProperty( "textLineThrough" ) );
		
//		Set the under line
		dataHandle.setProperty( StyleHandle.TEXT_UNDERLINE_PROP , "underline" );
		assertEquals( "underline" , dataHandle.getStringProperty( "textUnderline" ) );
	    
//	    Set the data color
	    dataHandle.setProperty( StyleHandle.COLOR_PROP , "Blue" );
	    assertEquals( "blue" , dataHandle.getStringProperty("color") );
	    	    
//		Set the data high
	    dataHandle.setHeight( "100pt" );
	    assertEquals( "100pt" , dataHandle.getHeight().getStringValue() );
	    
//	    Set the font size
		dataHandle.setProperty( StyleHandle.FONT_SIZE_PROP, "10pt" );
		assertEquals( "10pt" , dataHandle.getStringProperty( "fontSize" ) );
		
//		Set the font weight
		dataHandle.setProperty( StyleHandle.FONT_WEIGHT_PROP, "bold" );
		assertEquals( "bold" , dataHandle.getStringProperty("fontWeight") );
		
//		Set the font style
		dataHandle.setProperty( StyleHandle.FONT_STYLE_PROP, "italic");
    	assertEquals( "italic" , dataHandle.getStringProperty("fontStyle") );

//    	Set the data background color
		dataHandle.setProperty( StyleHandle.BACKGROUND_COLOR_PROP, "Red" );
		assertEquals( "red" , dataHandle.getStringProperty( "backgroundColor" ) );
		
//		Set border bottom color
		dataHandle.setProperty( StyleHandle.BORDER_BOTTOM_COLOR_PROP, "Blue" );
		assertEquals( "blue" , dataHandle.getStringProperty( "borderBottomColor" ) );
		
//		Set border bottom width
		dataHandle.setProperty( StyleHandle.BORDER_BOTTOM_WIDTH_PROP, "10pt" );
		assertEquals( "10pt" , dataHandle.getStringProperty( "borderBottomWidth" ) );
		
//		Set border left color
		dataHandle.setProperty( StyleHandle.BORDER_LEFT_COLOR_PROP, "Green" );
		assertEquals( "green" , dataHandle.getStringProperty( "borderLeftColor" ) );
		
//		Set border left width
		dataHandle.setProperty( StyleHandle.BORDER_LEFT_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , dataHandle.getStringProperty( "borderLeftWidth" ) );
		
//		Set border right color
        dataHandle.setProperty( StyleHandle.BORDER_RIGHT_COLOR_PROP, "Yellow" );
        assertEquals( "yellow" , dataHandle.getStringProperty( "borderRightColor" ) );
		
//      Set border right width
		dataHandle.setProperty( StyleHandle.BORDER_RIGHT_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , dataHandle.getStringProperty( "borderRightWidth" ) );
		
//		Set border top color
        dataHandle.setProperty( StyleHandle.BORDER_TOP_COLOR_PROP, "White" );
        assertEquals( "white" , dataHandle.getStringProperty( "borderTopColor" ) );
		
//        Set border top width
		dataHandle.setProperty( StyleHandle.BORDER_TOP_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , dataHandle.getStringProperty( "borderTopWidth" ) );
		
//		Set magin bottom
		dataHandle.setProperty( StyleHandle.MARGIN_BOTTOM_PROP, "5pt" );
		assertEquals( "5pt" , dataHandle.getStringProperty( "marginBottom" ) );
		
//		Set magin top
		dataHandle.setProperty( StyleHandle.MARGIN_TOP_PROP, "5pt" );
		assertEquals( "5pt" , dataHandle.getStringProperty( "marginTop" ) );
		
//		Set magin right
		dataHandle.setProperty( StyleHandle.MARGIN_RIGHT_PROP, "5pt" );
		assertEquals( "5pt" , dataHandle.getStringProperty( "marginRight" ) );
		
//		Set magin left
		dataHandle.setProperty( StyleHandle.MARGIN_LEFT_PROP, "5pt" );
		assertEquals( "5pt" , dataHandle.getStringProperty( "marginLeft" ) );
		
//		Setpadding bottom
		dataHandle.setProperty( StyleHandle.PADDING_BOTTOM_PROP, "8pt" );
		assertEquals( "8pt" , dataHandle.getStringProperty( "paddingBottom" ) );
		
//		Setpadding left
		dataHandle.setProperty( StyleHandle.PADDING_LEFT_PROP, "8pt" );
		assertEquals( "8pt" , dataHandle.getStringProperty( "paddingLeft" ) );
		
//		Setpadding right
		dataHandle.setProperty( StyleHandle.PADDING_RIGHT_PROP, "8pt" );		
		assertEquals( "8pt" , dataHandle.getStringProperty( "paddingRight" ) );
		
//		Setpadding top
		dataHandle.setProperty( StyleHandle.PADDING_TOP_PROP, "8pt" );
		assertEquals( "8pt" , dataHandle.getStringProperty( "paddingTop" ) );
		
//		Set page break before
		dataHandle.setProperty( StyleHandle.PAGE_BREAK_BEFORE_PROP, "avoid" );
		assertEquals( "avoid", dataHandle.getStringProperty( "pageBreakBefore" ) );
		
//		Set page break after
		dataHandle.setProperty( StyleHandle.PAGE_BREAK_AFTER_PROP, "Always" );
		assertEquals( "always", dataHandle.getStringProperty( "pageBreakAfter" ) );	
		

		super.saveAs( outFileName );
		assertTrue( compareTextFile( goldenFileName, outFileName ) );
	}
}
