package org.eclipse.birt.report.tests.model.smoke;

import java.io.InputStream;
import java.util.ArrayList;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

import com.ibm.icu.util.ULocale;

public class ExternalCssStyleSheetTest2 extends BaseTestCase {

	private String fileName = null;
	
	public ExternalCssStyleSheetTest2(String name) {
		super(name);
	}

	public static Test suite() {

		return new TestSuite(ExternalCssStyleSheetTest2.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	//	Platform.initialize( null );
		SessionHandle session = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = session.createDesign( );
	}

	public void testImportExternalCssStyleSheet() throws Exception {
			
		//open a external style sheet with inputstream
		
		fileName = "ExternalCssStyleSheetTest2.css";
		CssStyleSheetHandle stylesheet = loadStyleSheet( fileName );
		assertNotNull(stylesheet);
		SharedStyleHandle style1 = stylesheet.findStyle("STYLE1");
		SharedStyleHandle style2 = stylesheet.findStyle("STYLE2");
		assertNotNull(style1);
		assertNotNull(style2);
		ArrayList styleList = new ArrayList();
		styleList.add(0, style1);
		styleList.add(1, style2);
		assertEquals(2,styleList.size());
		
		//import a external style sheet into a report design
		designHandle.importCssStyles(stylesheet, styleList);
		assertEquals(2,designHandle.getStyles().getCount());
}
    
	private CssStyleSheetHandle loadStyleSheet( String fileName )
	throws Exception
       {
		fileName = getFullQualifiedClassName( ) + INPUT_FOLDER + fileName;
		InputStream is = ExternalCssStyleSheetTest2.class
		.getResourceAsStream( fileName );
		return designHandle.openCssStyleSheet( is );
       }	
}
