package org.eclipse.birt.report.tests.model.smoke;

import java.io.InputStream;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.elements.interfaces.IStyleModel;
import org.eclipse.birt.report.tests.model.BaseTestCase;

import com.ibm.icu.util.ULocale;

public class ExternalCssStyleSheetTest5 extends BaseTestCase
{

	private String fileName = null;
	private CssStyleSheetHandle cssStyleSheetHandle = null;
	private SharedStyleHandle style1 = null;
	private SharedStyleHandle style2 = null;
	private SharedStyleHandle style3 = null;
	private SharedStyleHandle style4 = null;
	private SharedStyleHandle style5 = null;
	private SharedStyleHandle style6 = null;
	
	
	public ExternalCssStyleSheetTest5(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}
	public static Test suite( )
	{
		return new TestSuite( ExternalCssStyleSheetTest5.class );
	}

	public void setUp( ) throws Exception
	{
		super.setUp( );
	//	Platform.initialize( null );
		SessionHandle designSession = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = designSession.createDesign( );
		fileName = "ExternalCssStyleSheetTest5.css";
	    cssStyleSheetHandle = loadStyleSheet( fileName );
		style1 = cssStyleSheetHandle.findStyle( "table1" );
		style2 = cssStyleSheetHandle.findStyle( "table2" );
		style3 = cssStyleSheetHandle.findStyle( "table3" );
		style4 = cssStyleSheetHandle.findStyle( "table4" );
		style5 = cssStyleSheetHandle.findStyle( "table5" );
		style6 = cssStyleSheetHandle.findStyle( "table6" );
		assertNotNull(style1);
		assertNotNull(style2);
		assertNotNull(style3);
		assertNotNull(style4);
		assertNotNull(style5);
		assertNotNull(style6);
	}
	private CssStyleSheetHandle loadStyleSheet( String fileName ) throws Exception
    {
		fileName = getFullQualifiedClassName( ) + INPUT_FOLDER + fileName;
		InputStream is = ExternalCssStyleSheetTest5.class.getResourceAsStream( fileName );
		return designHandle.openCssStyleSheet( is );
    }
	public void testShorthandProperties( ) throws Exception
	{
		/*background*/
		/*background-color*/
		assertEquals( "gray", style1.getStringProperty( IStyleModel.BACKGROUND_COLOR_PROP));
        assertEquals( "#FF0000", style2.getStringProperty( IStyleModel.BACKGROUND_COLOR_PROP));
		assertEquals( "blue", style3.getStringProperty( IStyleModel.BACKGROUND_COLOR_PROP));
        assertEquals( "#00FF00", style4.getStringProperty( IStyleModel.BACKGROUND_COLOR_PROP));
		assertEquals( "olive", style5.getStringProperty( IStyleModel.BACKGROUND_COLOR_PROP));
		assertEquals( "black", style6.getStringProperty( IStyleModel.BACKGROUND_COLOR_PROP));
		
		/*background-image*/
		assertEquals( "chess.png", style1.getStringProperty( IStyleModel.BACKGROUND_IMAGE_PROP));
		assertEquals( "chess.png", style2.getStringProperty( IStyleModel.BACKGROUND_IMAGE_PROP));
		assertEquals( "image.gif", style3.getStringProperty( IStyleModel.BACKGROUND_IMAGE_PROP));
		assertEquals( "image.gif", style4.getStringProperty( IStyleModel.BACKGROUND_IMAGE_PROP));
		assertNull(style5.getStringProperty( IStyleModel.BACKGROUND_IMAGE_PROP));
		assertNull(style6.getStringProperty( IStyleModel.BACKGROUND_IMAGE_PROP));
		
		/*background-repeat*/
		assertEquals( "repeat", style1.getStringProperty( IStyleModel.BACKGROUND_REPEAT_PROP));
        assertEquals( "repeat-x", style2.getStringProperty( IStyleModel.BACKGROUND_REPEAT_PROP));
		assertEquals( "no-repeat", style3.getStringProperty( IStyleModel.BACKGROUND_REPEAT_PROP));
		assertEquals( "repeat", style4.getStringProperty( IStyleModel.BACKGROUND_REPEAT_PROP));
        assertEquals( "repeat-y", style5.getStringProperty( IStyleModel.BACKGROUND_REPEAT_PROP));
		assertEquals( "repeat", style6.getStringProperty( IStyleModel.BACKGROUND_REPEAT_PROP));
		
		/*background-attachment*/
		assertEquals( "fixed", style1.getStringProperty( IStyleModel.BACKGROUND_ATTACHMENT_PROP));
		assertEquals( "fixed", style2.getStringProperty( IStyleModel.BACKGROUND_ATTACHMENT_PROP));
		assertEquals( "scroll", style3.getStringProperty( IStyleModel.BACKGROUND_ATTACHMENT_PROP));
		assertEquals( "scroll", style4.getStringProperty( IStyleModel.BACKGROUND_ATTACHMENT_PROP));
		assertEquals( "fixed", style5.getStringProperty( IStyleModel.BACKGROUND_ATTACHMENT_PROP));
		assertEquals( "fixed", style6.getStringProperty( IStyleModel.BACKGROUND_ATTACHMENT_PROP));
		
		/*background-position*/
		assertEquals( "2cm", style1.getStringProperty( IStyleModel.BACKGROUND_POSITION_X_PROP));
		assertEquals( "0%", style1.getStringProperty( IStyleModel.BACKGROUND_POSITION_Y_PROP));
	
    	assertEquals( "40%", style2.getStringProperty( IStyleModel.BACKGROUND_POSITION_X_PROP));
		assertEquals( "20%", style2.getStringProperty( IStyleModel.BACKGROUND_POSITION_Y_PROP));
		
        assertEquals( "50%", style3.getStringProperty( IStyleModel.BACKGROUND_POSITION_X_PROP));
		assertEquals( "2cm", style3.getStringProperty( IStyleModel.BACKGROUND_POSITION_Y_PROP));
		
		assertEquals( "right", style4.getStringProperty( IStyleModel.BACKGROUND_POSITION_X_PROP));
		assertEquals( "top", style4.getStringProperty( IStyleModel.BACKGROUND_POSITION_Y_PROP));
		
        assertEquals( "center", style5.getStringProperty( IStyleModel.BACKGROUND_POSITION_X_PROP));
		assertEquals( "0%", style5.getStringProperty( IStyleModel.BACKGROUND_POSITION_Y_PROP));
		
	    assertEquals( "2cm", style6.getStringProperty( IStyleModel.BACKGROUND_POSITION_X_PROP));
		assertEquals( "1cm", style6.getStringProperty( IStyleModel.BACKGROUND_POSITION_Y_PROP));
		
		/*font*/
		assertEquals( "12pt", style1.getStringProperty( IStyleModel.FONT_SIZE_PROP));
		assertEquals( "sans-serif", style1.getStringProperty( IStyleModel.FONT_FAMILY_PROP));
		
		assertEquals( "80%", style2.getStringProperty( IStyleModel.FONT_SIZE_PROP));
        assertEquals( "sans-serif", style2.getStringProperty( IStyleModel.FONT_FAMILY_PROP));
		
		assertEquals( "x-large", style3.getStringProperty( IStyleModel.FONT_SIZE_PROP));
		assertEquals( "\"new century schoolbook\",serif", style3.getStringProperty( IStyleModel.FONT_FAMILY_PROP));
		
		assertEquals( "bold", style4.getStringProperty( IStyleModel.FONT_WEIGHT_PROP));
		assertEquals( "italic", style4.getStringProperty( IStyleModel.FONT_STYLE_PROP));
		assertEquals( "large", style4.getStringProperty( IStyleModel.FONT_SIZE_PROP));
		assertEquals( "palatino,serif", style4.getStringProperty( IStyleModel.FONT_FAMILY_PROP));
		
		assertEquals( "normal", style5.getStringProperty( IStyleModel.FONT_STYLE_PROP));
		assertEquals( "normal", style5.getStringProperty( IStyleModel.FONT_WEIGHT_PROP));
		assertEquals( "small-caps", style5.getStringProperty( IStyleModel.FONT_VARIANT_PROP));
		assertEquals( "120%", style5.getStringProperty( IStyleModel.FONT_SIZE_PROP));
		assertEquals( "fantasy", style5.getStringProperty( IStyleModel.FONT_FAMILY_PROP));
	
		assertEquals( "oblique", style6.getStringProperty( IStyleModel.FONT_STYLE_PROP));
		assertEquals( "12pt", style6.getStringProperty( IStyleModel.FONT_SIZE_PROP));
		assertEquals( "\"fontfamilyname\",serif", style6.getStringProperty( IStyleModel.FONT_FAMILY_PROP));
		
		/*margin*/
		assertEquals( "2em", style1.getStringProperty( IStyleModel.MARGIN_TOP_PROP));
		assertEquals( "2em", style1.getStringProperty( IStyleModel.MARGIN_RIGHT_PROP));
		assertEquals( "2em", style1.getStringProperty( IStyleModel.MARGIN_BOTTOM_PROP));
		assertEquals( "2em", style1.getStringProperty( IStyleModel.MARGIN_LEFT_PROP));
		
		assertEquals( "1cm", style2.getStringProperty( IStyleModel.MARGIN_TOP_PROP));
		assertEquals( "2cm", style2.getStringProperty( IStyleModel.MARGIN_RIGHT_PROP));
		assertEquals( "3cm", style2.getStringProperty( IStyleModel.MARGIN_BOTTOM_PROP));
		assertEquals( "2cm", style2.getStringProperty( IStyleModel.MARGIN_LEFT_PROP));
		
		assertEquals( "1cm", style3.getStringProperty( IStyleModel.MARGIN_TOP_PROP));
		assertEquals( "2cm", style3.getStringProperty( IStyleModel.MARGIN_RIGHT_PROP));
		assertEquals( "3cm", style3.getStringProperty( IStyleModel.MARGIN_BOTTOM_PROP));
		assertEquals( "4cm", style3.getStringProperty( IStyleModel.MARGIN_LEFT_PROP));
		
		/*padding*/
		assertEquals( "1em", style1.getStringProperty( IStyleModel.PADDING_TOP_PROP));
		assertEquals( "2em", style1.getStringProperty( IStyleModel.PADDING_RIGHT_PROP));
		assertEquals( "1em", style1.getStringProperty( IStyleModel.PADDING_BOTTOM_PROP));
		assertEquals( "2em", style1.getStringProperty( IStyleModel.PADDING_LEFT_PROP));
		
		assertEquals( "1em", style2.getStringProperty( IStyleModel.PADDING_TOP_PROP));
		assertEquals( "2em", style2.getStringProperty( IStyleModel.PADDING_RIGHT_PROP));
		assertEquals( "1em", style2.getStringProperty( IStyleModel.PADDING_BOTTOM_PROP));
		assertEquals( "2em", style2.getStringProperty( IStyleModel.PADDING_LEFT_PROP));
		
		assertEquals( "2pt", style4.getStringProperty( IStyleModel.PADDING_TOP_PROP));
		assertEquals( "2pt", style4.getStringProperty( IStyleModel.PADDING_RIGHT_PROP));
		assertEquals( "2pt", style4.getStringProperty( IStyleModel.PADDING_BOTTOM_PROP));
		assertEquals( "2pt", style4.getStringProperty( IStyleModel.PADDING_LEFT_PROP));
		
		assertEquals( "2pt", style5.getStringProperty( IStyleModel.PADDING_TOP_PROP));
		assertEquals( "1pt", style5.getStringProperty( IStyleModel.PADDING_RIGHT_PROP));
		assertEquals( "2cm", style5.getStringProperty( IStyleModel.PADDING_BOTTOM_PROP));
		assertEquals( "1pt", style5.getStringProperty( IStyleModel.PADDING_LEFT_PROP));
		
		/*border-width*/
		assertEquals( "thin", style1.getStringProperty( IStyleModel.BORDER_TOP_WIDTH_PROP));
		assertEquals( "thin", style1.getStringProperty( IStyleModel.BORDER_RIGHT_WIDTH_PROP));
		assertEquals( "thin", style1.getStringProperty( IStyleModel.BORDER_BOTTOM_WIDTH_PROP));
		assertEquals( "thin", style1.getStringProperty( IStyleModel.BORDER_LEFT_WIDTH_PROP));
				
		assertEquals( "2mm", style2.getStringProperty( IStyleModel.BORDER_TOP_WIDTH_PROP));
		
		assertEquals( "thin", style3.getStringProperty( IStyleModel.BORDER_TOP_WIDTH_PROP));
		assertEquals( "thin", style3.getStringProperty( IStyleModel.BORDER_RIGHT_WIDTH_PROP));
		assertEquals( "thin", style3.getStringProperty( IStyleModel.BORDER_BOTTOM_WIDTH_PROP));
		assertEquals( "thin", style3.getStringProperty( IStyleModel.BORDER_LEFT_WIDTH_PROP));
		
		assertEquals( "medium", style4.getStringProperty( IStyleModel.BORDER_TOP_WIDTH_PROP));
		assertEquals( "1pt", style4.getStringProperty( IStyleModel.BORDER_RIGHT_WIDTH_PROP));
		
		assertEquals( "thin", style5.getStringProperty( IStyleModel.BORDER_TOP_WIDTH_PROP));
		assertEquals( "thick", style5.getStringProperty( IStyleModel.BORDER_RIGHT_WIDTH_PROP));
		assertEquals( "medium", style5.getStringProperty( IStyleModel.BORDER_BOTTOM_WIDTH_PROP));
		assertEquals( "thick", style5.getStringProperty( IStyleModel.BORDER_LEFT_WIDTH_PROP));
		
		assertEquals( "thin", style6.getStringProperty( IStyleModel.BORDER_TOP_WIDTH_PROP));
		assertEquals( "thick", style6.getStringProperty( IStyleModel.BORDER_RIGHT_WIDTH_PROP));
		assertEquals( "medium", style6.getStringProperty( IStyleModel.BORDER_BOTTOM_WIDTH_PROP));
		assertEquals( "thick", style6.getStringProperty( IStyleModel.BORDER_LEFT_WIDTH_PROP));
		
		/*border-style*/
		assertEquals( "solid", style1.getStringProperty( IStyleModel.BORDER_TOP_STYLE_PROP));
		assertEquals( "solid", style1.getStringProperty( IStyleModel.BORDER_RIGHT_STYLE_PROP));
		assertEquals( "solid", style1.getStringProperty( IStyleModel.BORDER_BOTTOM_STYLE_PROP));
		assertEquals( "solid", style1.getStringProperty( IStyleModel.BORDER_LEFT_STYLE_PROP));
		
		assertEquals( "solid", style2.getStringProperty( IStyleModel.BORDER_TOP_STYLE_PROP));
		
        assertEquals( "dotted", style3.getStringProperty( IStyleModel.BORDER_TOP_STYLE_PROP));
		assertEquals( "dashed", style3.getStringProperty( IStyleModel.BORDER_RIGHT_STYLE_PROP));
		assertEquals( "double", style3.getStringProperty( IStyleModel.BORDER_BOTTOM_STYLE_PROP));
		assertEquals( "ridge", style3.getStringProperty( IStyleModel.BORDER_LEFT_STYLE_PROP));
		
		assertEquals( "dashed", style4.getStringProperty( IStyleModel.BORDER_TOP_STYLE_PROP));
		assertEquals( "double", style4.getStringProperty( IStyleModel.BORDER_RIGHT_STYLE_PROP));
		assertEquals( "ridge", style4.getStringProperty( IStyleModel.BORDER_BOTTOM_STYLE_PROP));
		
		assertEquals( "none", style5.getStringProperty( IStyleModel.BORDER_TOP_STYLE_PROP));
		assertEquals( "dotted", style5.getStringProperty( IStyleModel.BORDER_RIGHT_STYLE_PROP));
		assertEquals( "solid", style5.getStringProperty( IStyleModel.BORDER_BOTTOM_STYLE_PROP));
		assertEquals( "groove", style5.getStringProperty( IStyleModel.BORDER_LEFT_STYLE_PROP));
		
		assertEquals( "dashed", style6.getStringProperty( IStyleModel.BORDER_TOP_STYLE_PROP));
		assertEquals( "dashed", style6.getStringProperty( IStyleModel.BORDER_RIGHT_STYLE_PROP));
		assertEquals( "dashed", style6.getStringProperty( IStyleModel.BORDER_BOTTOM_STYLE_PROP));
		assertEquals( "dashed", style6.getStringProperty( IStyleModel.BORDER_LEFT_STYLE_PROP));
		
		/*border-color*/
		assertEquals( "red", style1.getStringProperty( IStyleModel.BORDER_TOP_COLOR_PROP));
		assertEquals( "red", style1.getStringProperty( IStyleModel.BORDER_RIGHT_COLOR_PROP));
		assertEquals( "red", style1.getStringProperty( IStyleModel.BORDER_BOTTOM_COLOR_PROP));
		assertEquals( "red", style1.getStringProperty( IStyleModel.BORDER_LEFT_COLOR_PROP));
		
		assertEquals( "red", style2.getStringProperty( IStyleModel.BORDER_TOP_COLOR_PROP));
		
		assertEquals( "#000000", style4.getStringProperty( IStyleModel.BORDER_TOP_COLOR_PROP));
		
		assertEquals( "yellow", style5.getStringProperty( IStyleModel.BORDER_TOP_COLOR_PROP));
		assertEquals( "yellow", style5.getStringProperty( IStyleModel.BORDER_RIGHT_COLOR_PROP));
		assertEquals( "yellow", style5.getStringProperty( IStyleModel.BORDER_BOTTOM_COLOR_PROP));
		assertEquals( "yellow", style5.getStringProperty( IStyleModel.BORDER_LEFT_COLOR_PROP));
		
		assertEquals( "gray", style6.getStringProperty( IStyleModel.BORDER_TOP_COLOR_PROP));
		assertEquals( "gray", style6.getStringProperty( IStyleModel.BORDER_RIGHT_COLOR_PROP));
		assertEquals( "gray", style6.getStringProperty( IStyleModel.BORDER_BOTTOM_COLOR_PROP));
		assertEquals( "gray", style6.getStringProperty( IStyleModel.BORDER_LEFT_COLOR_PROP));
		
	 }
	
	public void testWrongShorthandProperties( ) throws Exception
	{
		SharedStyleHandle style7 = cssStyleSheetHandle.findStyle( "table7" );
		assertNotNull(style7);
		
	    assertEquals("scroll",style7.getStringProperty(IStyleModel.BACKGROUND_ATTACHMENT_PROP));
		assertEquals("#00FF00",style7.getStringProperty(IStyleModel.BACKGROUND_COLOR_PROP));
		assertNull(style7.getStringProperty(IStyleModel.BACKGROUND_IMAGE_PROP));
		assertEquals("0%",style7.getStringProperty(IStyleModel.BACKGROUND_POSITION_X_PROP));
		assertEquals("0%",style7.getStringProperty(IStyleModel.BACKGROUND_POSITION_Y_PROP));
		assertEquals("repeat",style7.getStringProperty(IStyleModel.BACKGROUND_REPEAT_PROP)); 
		

	}
	
	
	
	
}
	  
	

