package org.eclipse.birt.report.tests.model.smoke;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class GridElementHandleTest extends BaseTestCase
{
	String fileName = "BlankReport.xml";
	
	private String outFileName = "GridElementHandleDpt.xml"; 
	private String goldenFileName = "GridElementHandleDpt_golden.xml"; 
	String TempFile= getClassFolder() + OUTPUT_FOLDER + outFileName;
	
	public GridElementHandleTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(GridElementHandleTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testGridElement( ) throws Exception
	{
		openDesign( fileName );
		
//		New a 3*3 grid without name.
		GridHandle gridHandle = (GridHandle)designHandle.getElementFactory().newGridItem( "" , 3, 3 );
		designHandle.getBody().add( gridHandle );
		
//		Test column
		assertEquals( 3, gridHandle.getColumnCount( ) );
		
		SlotHandle slotHandle = gridHandle.getColumns( );
		assertEquals( 3, slotHandle.getCount( ) );

		slotHandle = gridHandle.getRows( );
		assertEquals( 3, slotHandle.getCount( ) );
		
//		Test on row properties.
		slotHandle = gridHandle.getRows( );
		assertEquals( 3, slotHandle.getCount( ) );
		
//		Set grid name
		gridHandle.setName( "myGrid" );
		assertEquals( "myGrid" , gridHandle.getName() );
		
//		Set grid height
		gridHandle.setHeight( "100pt" );
		assertEquals( "100pt" , gridHandle.getHeight().getStringValue() );
		
//		Set grid width
		gridHandle.setWidth( "100pt" );
		assertEquals( "100pt" , gridHandle.getWidth().getStringValue() );
		
//	    Set the font size
	    gridHandle.setProperty( StyleHandle.FONT_SIZE_PROP, "10pt" );
		assertEquals( "10pt" , gridHandle.getStringProperty( "fontSize" ) );
		
//		Set the font weight
		gridHandle.setProperty( StyleHandle.FONT_WEIGHT_PROP, "bold" );
		assertEquals( "bold" , gridHandle.getStringProperty("fontWeight") );
		
//		Set the font style
		gridHandle.setProperty( StyleHandle.FONT_STYLE_PROP, "italic");
    	assertEquals( "italic" , gridHandle.getStringProperty("fontStyle") );
		
//    	Set the grid background color
    	gridHandle.setProperty( StyleHandle.BACKGROUND_COLOR_PROP, "Red" );
		assertEquals( "red" , gridHandle.getStringProperty( "backgroundColor" ) );
		
//		Set border bottom color
		gridHandle.setProperty( StyleHandle.BORDER_BOTTOM_COLOR_PROP, "Blue" );
		assertEquals( "blue" , gridHandle.getStringProperty( "borderBottomColor" ) );
		
//		Set border bottom width
		gridHandle.setProperty( StyleHandle.BORDER_BOTTOM_WIDTH_PROP, "10pt" );
		assertEquals( "10pt" , gridHandle.getStringProperty( "borderBottomWidth" ) );
		
//		Set border left color
		gridHandle.setProperty( StyleHandle.BORDER_LEFT_COLOR_PROP, "Green" );
		assertEquals( "green" , gridHandle.getStringProperty( "borderLeftColor" ) );
		
//		Set border left width
		gridHandle.setProperty( StyleHandle.BORDER_LEFT_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , gridHandle.getStringProperty( "borderLeftWidth" ) );
		
//		Set border right color
		gridHandle.setProperty( StyleHandle.BORDER_RIGHT_COLOR_PROP, "Yellow" );
        assertEquals( "yellow" , gridHandle.getStringProperty( "borderRightColor" ) );
		
//      Set border right width
        gridHandle.setProperty( StyleHandle.BORDER_RIGHT_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , gridHandle.getStringProperty( "borderRightWidth" ) );
		
//		Set border top color
		gridHandle.setProperty( StyleHandle.BORDER_TOP_COLOR_PROP, "White" );
        assertEquals( "white" , gridHandle.getStringProperty( "borderTopColor" ) );
		
//        Set border top width
        gridHandle.setProperty( StyleHandle.BORDER_TOP_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , gridHandle.getStringProperty( "borderTopWidth" ) );
		
//		Set magin bottom
		gridHandle.setProperty( StyleHandle.MARGIN_BOTTOM_PROP, "5pt" );
		assertEquals( "5pt" , gridHandle.getStringProperty( "marginBottom" ) );
		
//		Set magin top
		gridHandle.setProperty( StyleHandle.MARGIN_TOP_PROP, "5pt" );
		assertEquals( "5pt" , gridHandle.getStringProperty( "marginTop" ) );
		
//		Set magin right
		gridHandle.setProperty( StyleHandle.MARGIN_RIGHT_PROP, "5pt" );
		assertEquals( "5pt" , gridHandle.getStringProperty( "marginRight" ) );
		
//		Set magin left
		gridHandle.setProperty( StyleHandle.MARGIN_LEFT_PROP, "5pt" );
		assertEquals( "5pt" , gridHandle.getStringProperty( "marginLeft" ) );
		
//		Setpadding bottom
		gridHandle.setProperty( StyleHandle.PADDING_BOTTOM_PROP, "8pt" );
		assertEquals( "8pt" , gridHandle.getStringProperty( "paddingBottom" ) );
		
//		Setpadding left
		gridHandle.setProperty( StyleHandle.PADDING_LEFT_PROP, "8pt" );
		assertEquals( "8pt" , gridHandle.getStringProperty( "paddingLeft" ) );
		
//		Setpadding right
		gridHandle.setProperty( StyleHandle.PADDING_RIGHT_PROP, "8pt" );		
		assertEquals( "8pt" , gridHandle.getStringProperty( "paddingRight" ) );
		
//		Setpadding top
		gridHandle.setProperty( StyleHandle.PADDING_TOP_PROP, "8pt" );
		assertEquals( "8pt" , gridHandle.getStringProperty( "paddingTop" ) );
		
//		Set page break before
		gridHandle.setProperty( StyleHandle.PAGE_BREAK_BEFORE_PROP, "avoid" );
		assertEquals( "avoid", gridHandle.getStringProperty( "pageBreakBefore" ) );
		
//		Set page break after
		gridHandle.setProperty( StyleHandle.PAGE_BREAK_AFTER_PROP, "Always" );
		assertEquals( "always", gridHandle.getStringProperty( "pageBreakAfter" ) );
		
		ColumnBandData column = gridHandle.copyColumn(1);
		assertEquals( 3 , gridHandle.getColumnCount());
		
		gridHandle.insertAndPasteColumn( column , 2 );
		assertEquals( 4 , gridHandle.getColumnCount());
			
		designHandle.saveAs( TempFile );
		assertTrue( compareTextFile( goldenFileName, outFileName ) );
	}
	
	
	public void testGridColumn( ) throws Exception
	{
		openDesign( fileName );
		
//		New a 3*3 grid without name.
		GridHandle gridHandle = (GridHandle)designHandle.getElementFactory().newGridItem( "GridColumn" , 3, 3 );
		designHandle.getBody().add( gridHandle );
		
		SlotHandle column = gridHandle.getColumns();
		ColumnHandle gridColumn = (ColumnHandle) column.get( 1 );
		
//	    Set the font size
		gridColumn.setProperty( StyleHandle.FONT_SIZE_PROP, "10pt" );
		assertEquals( "10pt" , gridColumn.getStringProperty( "fontSize" ) );
		
//		Set the font weight
		gridColumn.setProperty( StyleHandle.FONT_WEIGHT_PROP, "bold" );
		assertEquals( "bold" , gridColumn.getStringProperty("fontWeight") );
		
//		Set the font style
		gridColumn.setProperty( StyleHandle.FONT_STYLE_PROP, "italic");
    	assertEquals( "italic" , gridColumn.getStringProperty("fontStyle") );
		
//    	Set the grid background color
    	gridColumn.setProperty( StyleHandle.BACKGROUND_COLOR_PROP, "Red" );
		assertEquals( "red" , gridColumn.getStringProperty( "backgroundColor" ) );
		
//	    Set the line fo through
		gridColumn.setProperty( StyleHandle.TEXT_LINE_THROUGH_PROP , "line-through" );
		assertEquals( "line-through" , gridColumn.getStringProperty( "textLineThrough" ) );
		
//		Set the under line
		gridColumn.setProperty( StyleHandle.TEXT_UNDERLINE_PROP , "underline" );
		assertEquals( "underline" , gridColumn.getStringProperty( "textUnderline" ) );
		
//	    Set the grid column color
		gridColumn.setProperty( StyleHandle.COLOR_PROP , "Blue" );
	    assertEquals( "blue" , gridColumn.getStringProperty("color") );
	    
//	    Set the grid column color align
	    gridColumn.setProperty( StyleHandle.TEXT_ALIGN_PROP , "Right" );
	    assertEquals( "right" , gridColumn.getStringProperty("textAlign") );
	}
	
	
	
	public void testGridRow( ) throws Exception
	{
		openDesign( fileName );
		
//		New a 3*3 grid without name.
		GridHandle gridHandle = (GridHandle)designHandle.getElementFactory().newGridItem( "GridRow" , 3, 3 );
		designHandle.getBody().add( gridHandle );
		
		SlotHandle row = gridHandle.getRows();
		RowHandle gridRow = (RowHandle) row.get( 1 );
		
//	    Set the font size
		gridRow.setProperty( StyleHandle.FONT_SIZE_PROP, "10pt" );
		assertEquals( "10pt" , gridRow.getStringProperty( "fontSize" ) );
		
//		Set the font weight
		gridRow.setProperty( StyleHandle.FONT_WEIGHT_PROP, "bold" );
		assertEquals( "bold" , gridRow.getStringProperty("fontWeight") );
		
//		Set the font style
		gridRow.setProperty( StyleHandle.FONT_STYLE_PROP, "italic");
    	assertEquals( "italic" , gridRow.getStringProperty("fontStyle") );
		
//    	Set the grid background color
    	gridRow.setProperty( StyleHandle.BACKGROUND_COLOR_PROP, "Red" );
		assertEquals( "red" , gridRow.getStringProperty( "backgroundColor" ) );
		
//	    Set the line fo through
		gridRow.setProperty( StyleHandle.TEXT_LINE_THROUGH_PROP , "line-through" );
		assertEquals( "line-through" , gridRow.getStringProperty( "textLineThrough" ) );
		
//		Set the under line
		gridRow.setProperty( StyleHandle.TEXT_UNDERLINE_PROP , "underline" );
		assertEquals( "underline" , gridRow.getStringProperty( "textUnderline" ) );
		
//	    Set the grid column color
		gridRow.setProperty( StyleHandle.COLOR_PROP , "Blue" );
	    assertEquals( "blue" , gridRow.getStringProperty("color") );
	    
//	    Set the grid column color align
	    gridRow.setProperty( StyleHandle.TEXT_ALIGN_PROP , "Right" );
	    assertEquals( "right" , gridRow.getStringProperty("textAlign") );
	}
	
	
	public void testGridCell( ) throws Exception
	{
		openDesign( fileName );
		
//		New a 3*3 grid without name.
		GridHandle gridHandle = (GridHandle)designHandle.getElementFactory().newGridItem( "GridCell" , 3, 3 );
		designHandle.getBody().add( gridHandle );
		
//	    Set the font size
		gridHandle.getCell(1,1).setProperty( StyleHandle.FONT_SIZE_PROP, "10pt" );
		assertEquals( "10pt" , gridHandle.getCell(1,1).getStringProperty( "fontSize" ) );
		
//		Set the font weight
		gridHandle.getCell(1,1).setProperty( StyleHandle.FONT_WEIGHT_PROP, "bold" );
		assertEquals( "bold" , gridHandle.getCell(1,1).getStringProperty("fontWeight") );
		
//		Set the font style
		gridHandle.getCell(1,1).setProperty( StyleHandle.FONT_STYLE_PROP, "italic");
    	assertEquals( "italic" , gridHandle.getCell(1,1).getStringProperty("fontStyle") );
		
//    	Set the cell background color
    	gridHandle.getCell(1,1).setProperty( StyleHandle.BACKGROUND_COLOR_PROP, "Red" );
		assertEquals( "red" , gridHandle.getCell(1,1).getStringProperty( "backgroundColor" ) );
		
//	    Set the line fo through
		gridHandle.getCell(1,1).setProperty( StyleHandle.TEXT_LINE_THROUGH_PROP , "line-through" );
		assertEquals( "line-through" , gridHandle.getCell(1,1).getStringProperty( "textLineThrough" ) );
		
//		Set the under line
		gridHandle.getCell(1,1).setProperty( StyleHandle.TEXT_UNDERLINE_PROP , "underline" );
		assertEquals( "underline" , gridHandle.getCell(1,1).getStringProperty( "textUnderline" ) );
		
//	    Set the cell color
		gridHandle.getCell(1,1).setProperty( StyleHandle.COLOR_PROP , "Blue" );
	    assertEquals( "blue" , gridHandle.getCell(1,1).getStringProperty("color") );
	    
//	    Set the cell color align
	    gridHandle.getCell(1,1).setProperty( StyleHandle.TEXT_ALIGN_PROP , "Right" );
	    assertEquals( "right" , gridHandle.getCell(1,1).getStringProperty("textAlign") );
	}
}
