package org.eclipse.birt.report.tests.model.smoke;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;
import org.eclipse.birt.report.model.api.StyleHandle;


public class ImageElementHandleTest extends BaseTestCase
{

	String fileName = "BlankReport.xml";
	private String outFileName = "ImageElementHandleDpt.xml"; 
	private String goldenFileName = "ImageElementHandleDpt_golden.xml"; 
	String TempFile= getClassFolder() + OUTPUT_FOLDER + outFileName;
	
	public ImageElementHandleTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(ImageElementHandleTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testImageElement( ) throws Exception
	{
		openDesign( fileName );
		ImageHandle imageHandle = (ImageHandle)designHandle.getElementFactory().newImage( "" );
		designHandle.getBody().add( imageHandle );
		
//		Set image name
		imageHandle.setImageName( "myImage" );
		assertEquals( "myImage" , imageHandle.getImageName() );
		
//		Set image URI
		imageHandle.setURI( "http://www.google.com/intl/zh-CN_ALL/images/logo.gif" );
		assertEquals( "http://www.google.com/intl/zh-CN_ALL/images/logo.gif" , imageHandle.getURI() );
		
//		Set image height
		imageHandle.setHeight( "50mm" );		
		assertEquals( "50mm", imageHandle.getHeight( ).getStringValue( ) ); //$NON-NLS-1$
		assertEquals( "mm", imageHandle.getHeight( ).getUnits( ) );
		
//		Set image width
		imageHandle.setWidth( "90mm" );
		assertEquals( "90mm" , imageHandle.getWidth().getStringValue() );
		assertEquals( "mm" , imageHandle.getWidth().getUnits() );
		
//		Set image border bottom color
		imageHandle.setProperty( StyleHandle.BORDER_BOTTOM_COLOR_PROP , "Red" );
		assertEquals( "red" , imageHandle.getStringProperty( "borderBottomColor" ) );
		
//		Set image border bottom width
		imageHandle.setProperty( StyleHandle.BORDER_BOTTOM_WIDTH_PROP , "10pt" );
		assertEquals( "10pt" , imageHandle.getStringProperty( "borderBottomWidth" ) );
		
//		Set image border top color
		imageHandle.setProperty( StyleHandle.BORDER_TOP_COLOR_PROP , "Green" );
		assertEquals( "green" , imageHandle.getStringProperty( "borderTopColor" ) );
		
//		Set image border top width
		imageHandle.setProperty( StyleHandle.BORDER_TOP_WIDTH_PROP , "10pt" );
		assertEquals( "10pt" , imageHandle.getStringProperty( "borderTopWidth" ) );
		
//		Set image border left color
		imageHandle.setProperty( StyleHandle.BORDER_LEFT_COLOR_PROP , "Blue" );
		assertEquals( "blue" , imageHandle.getStringProperty( "borderLeftColor" ) );
		
//		Set image border left width
		imageHandle.setProperty( StyleHandle.BORDER_LEFT_WIDTH_PROP , "10pt" );
		assertEquals( "10pt" , imageHandle.getStringProperty( "borderLeftWidth" ) );
		
//		Set image border right color
		imageHandle.setProperty( StyleHandle.BORDER_RIGHT_COLOR_PROP , "Yellow" );
		assertEquals( "yellow" , imageHandle.getStringProperty( "borderRightColor" ) );
		
//		Set image border right width
		imageHandle.setProperty( StyleHandle.BORDER_RIGHT_WIDTH_PROP , "10pt" );
		assertEquals( "10pt" , imageHandle.getStringProperty( "borderRightWidth" ) );
		
//		Set image help text
		imageHandle.setHelpText( "Help from image!" );
		assertEquals( "Help from image!" , imageHandle.getHelpText() );
		
		
//		Set page break before
		imageHandle.setProperty( StyleHandle.PAGE_BREAK_BEFORE_PROP, "avoid" );
		assertEquals( "avoid", imageHandle.getStringProperty( "pageBreakBefore" ) );
		
//		Set page break after
		imageHandle.setProperty( StyleHandle.PAGE_BREAK_AFTER_PROP, "Always" );
		assertEquals( "always", imageHandle.getStringProperty( "pageBreakAfter" ) );	
		
		designHandle.saveAs( TempFile );
		assertTrue( compareTextFile( goldenFileName, outFileName ) );
	}
}
