package org.eclipse.birt.report.tests.model.smoke;

import junit.framework.Test;
import junit.framework.TestSuite;


import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class LabelElementHandleTest extends BaseTestCase
{
	String fileName = "BlankReport.xml";
	private String outFileName = "LabelElementHandleDpt.xml"; 
	private String goldenFileName = "LabelElementHandleDpt_golden.xml"; 
	String TempFile= getClassFolder() + OUTPUT_FOLDER + outFileName;
	
	public LabelElementHandleTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(LabelElementHandleTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testLabelElement( ) throws Exception
	{
		openDesign(fileName);
		
//		New a label without name.
		LabelHandle labelHandle = (LabelHandle)designHandle.getElementFactory().newLabel( "" );
		designHandle.getBody().add( labelHandle );
		
//		Set the label name
	    labelHandle.setName( "myLabel" );
	    assertEquals( "myLabel",  labelHandle.getName() );
	    
//	    Set the label content
	    labelHandle.setText( "Label1" );
	    assertEquals( "Label1" , labelHandle.getText() );

	    
//	    Set the label font family
	    labelHandle.setProperty( StyleHandle.FONT_FAMILY_PROP , "Sans Serif" );
	    assertEquals( "sans-serif" , labelHandle.getStringProperty( "fontFamily" ));
	    
//	    Set the label color
	    labelHandle.setProperty( StyleHandle.COLOR_PROP , "Blue" );
	    assertEquals( "blue" , labelHandle.getStringProperty("color") );
	    
//	    Set the label align
	    labelHandle.setProperty( StyleHandle.TEXT_ALIGN_PROP , "Right" );
	    assertEquals( "right" , labelHandle.getStringProperty("textAlign") );
	    
//	    Set the line fo through
	    labelHandle.setProperty( StyleHandle.TEXT_LINE_THROUGH_PROP , "line-through" );
		assertEquals( "line-through" , labelHandle.getStringProperty( "textLineThrough" ) );
		
//		Set the under line
		labelHandle.setProperty( StyleHandle.TEXT_UNDERLINE_PROP , "underline" );
		assertEquals( "underline" , labelHandle.getStringProperty( "textUnderline" ) );
	    
//		Set the label high
		labelHandle.setHeight( "100pt" );
	    assertEquals( "100pt" , labelHandle.getHeight().getStringValue() );
	    
//	    Set the font size
	    labelHandle.setProperty( StyleHandle.FONT_SIZE_PROP, "10pt" );
		assertEquals( "10pt" , labelHandle.getStringProperty( "fontSize" ) );
		
//		Set the font weight
		labelHandle.setProperty( StyleHandle.FONT_WEIGHT_PROP, "bold" );
		assertEquals( "bold" , labelHandle.getStringProperty("fontWeight") );
		
//		Set the font style
		labelHandle.setProperty( StyleHandle.FONT_STYLE_PROP, "italic");
    	assertEquals( "italic" , labelHandle.getStringProperty("fontStyle") );

//    	Set the label background color
    	labelHandle.setProperty( StyleHandle.BACKGROUND_COLOR_PROP, "Red" );
		assertEquals( "red" , labelHandle.getStringProperty( "backgroundColor" ) );
		
//		Set border bottom color
		labelHandle.setProperty( StyleHandle.BORDER_BOTTOM_COLOR_PROP, "Blue" );
		assertEquals( "blue" , labelHandle.getStringProperty( "borderBottomColor" ) );
		
//		Set border bottom width
		labelHandle.setProperty( StyleHandle.BORDER_BOTTOM_WIDTH_PROP, "10pt" );
		assertEquals( "10pt" , labelHandle.getStringProperty( "borderBottomWidth" ) );
		
//		Set border left color
		labelHandle.setProperty( StyleHandle.BORDER_LEFT_COLOR_PROP, "Green" );
		assertEquals( "green" , labelHandle.getStringProperty( "borderLeftColor" ) );
		
//		Set border left width
		labelHandle.setProperty( StyleHandle.BORDER_LEFT_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , labelHandle.getStringProperty( "borderLeftWidth" ) );
		
//		Set border right color
		labelHandle.setProperty( StyleHandle.BORDER_RIGHT_COLOR_PROP, "Yellow" );
        assertEquals( "yellow" , labelHandle.getStringProperty( "borderRightColor" ) );
		
//      Set border right width
        labelHandle.setProperty( StyleHandle.BORDER_RIGHT_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , labelHandle.getStringProperty( "borderRightWidth" ) );
		
//		Set border top color
		labelHandle.setProperty( StyleHandle.BORDER_TOP_COLOR_PROP, "White" );
        assertEquals( "white" , labelHandle.getStringProperty( "borderTopColor" ) );
		
//        Set border top width
        labelHandle.setProperty( StyleHandle.BORDER_TOP_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , labelHandle.getStringProperty( "borderTopWidth" ) );
		
//		Set magin bottom
		labelHandle.setProperty( StyleHandle.MARGIN_BOTTOM_PROP, "5pt" );
		assertEquals( "5pt" , labelHandle.getStringProperty( "marginBottom" ) );
		
//		Set magin top
		labelHandle.setProperty( StyleHandle.MARGIN_TOP_PROP, "5pt" );
		assertEquals( "5pt" , labelHandle.getStringProperty( "marginTop" ) );
		
//		Set magin right
		labelHandle.setProperty( StyleHandle.MARGIN_RIGHT_PROP, "5pt" );
		assertEquals( "5pt" , labelHandle.getStringProperty( "marginRight" ) );
		
//		Set magin left
		labelHandle.setProperty( StyleHandle.MARGIN_LEFT_PROP, "5pt" );
		assertEquals( "5pt" , labelHandle.getStringProperty( "marginLeft" ) );
		
//		Setpadding bottom
		labelHandle.setProperty( StyleHandle.PADDING_BOTTOM_PROP, "8pt" );
		assertEquals( "8pt" , labelHandle.getStringProperty( "paddingBottom" ) );
		
//		Setpadding left
		labelHandle.setProperty( StyleHandle.PADDING_LEFT_PROP, "8pt" );
		assertEquals( "8pt" , labelHandle.getStringProperty( "paddingLeft" ) );
		
//		Setpadding right
		labelHandle.setProperty( StyleHandle.PADDING_RIGHT_PROP, "8pt" );		
		assertEquals( "8pt" , labelHandle.getStringProperty( "paddingRight" ) );
		
//		Setpadding top
		labelHandle.setProperty( StyleHandle.PADDING_TOP_PROP, "8pt" );
		assertEquals( "8pt" , labelHandle.getStringProperty( "paddingTop" ) );
		
//		Set page break before
		labelHandle.setProperty( StyleHandle.PAGE_BREAK_BEFORE_PROP, "avoid" );
		assertEquals( "avoid", labelHandle.getStringProperty( "pageBreakBefore" ) );
		
//		Set page break after
		labelHandle.setProperty( StyleHandle.PAGE_BREAK_AFTER_PROP, "Always" );
		assertEquals( "always", labelHandle.getStringProperty( "pageBreakAfter" ) );	
		

		designHandle.saveAs( TempFile );
		assertTrue( compareTextFile( goldenFileName, outFileName ) );
		}
}
