package org.eclipse.birt.report.tests.model.smoke;

import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.elements.DesignChoiceConstants;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.model.BaseTestCase;

import com.ibm.icu.util.ULocale;


public class MasterPageTest extends BaseTestCase
{
	static final String OUTPUT_FILE_NAME = "MasterPageTest_out.xml";
	public MasterPageTest(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}
	 public static Test suite()
	    {
			
			return new TestSuite(MasterPageTest.class);
		}
		protected void setUp( ) throws Exception
		{
			super.setUp( );
		}
		public void testAddElement( ) throws Exception, IOException
		{
			sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
			designHandle = sessionHandle.createDesign( );
			design = (ReportDesign) designHandle.getModule();

			ElementFactory factory = new ElementFactory( design );
			SimpleMasterPageHandle masterpage = factory.newSimpleMasterPage("MyPage");
			TextItemHandle text = factory.newTextItem("text");
			ImageHandle image = factory.newImage("image");
			ListHandle list = factory.newList("list");
			
			//pageheader can't contain multi-elements
			SlotHandle pageheader = masterpage.getPageHeader();
			pageheader.add(text);
			assertFalse(pageheader.canContain(image));
			
			//pagefooter can't contain elements like list,table...
			SlotHandle pagefooter = masterpage.getPageFooter();
			assertFalse(pagefooter.canContain(list));
			pagefooter.add(image);
			int id = designHandle.getMasterPages().getSlotID();
		    designHandle.addElement(masterpage,id);
			super.saveAs(OUTPUT_FILE_NAME);
		}
		public void testProperties( ) throws Exception
		{
			openDesign("MasterPageTest.xml"); //$NON-NLS-1$

			MasterPageHandle page = designHandle.findMasterPage( "MyPage" ); //$NON-NLS-1$
            
//			 switch the page type from "custom" to "A4/US Letter/etc." previous
			// height/with property
			// will be cleared.

			page.setPageType( DesignChoiceConstants.PAGE_SIZE_CUSTOM );
			page.setStringProperty( MasterPage.HEIGHT_PROP, "12.0in" ); //$NON-NLS-1$
			page.setStringProperty( MasterPage.WIDTH_PROP, "10.0in" ); //$NON-NLS-1$

			assertEquals( "12in", page.getStringProperty( MasterPage.HEIGHT_PROP ) ); //$NON-NLS-1$
			assertEquals( "10in", page.getStringProperty( MasterPage.WIDTH_PROP ) ); //$NON-NLS-1$

			// Set type to A4, height/width should have been cleaned.

			page.setPageType( DesignChoiceConstants.PAGE_SIZE_A4 );
			assertEquals( DesignChoiceConstants.PAGE_SIZE_A4, page
					.getStringProperty( MasterPage.TYPE_PROP ) ); //$NON-NLS-1$
			assertEquals( MasterPage.A4_HEIGHT, page.getStringProperty( MasterPage.HEIGHT_PROP ) );
			assertEquals( MasterPage.A4_HEIGHT, page.getHeight( ).getStringValue( ) );
			assertEquals( MasterPage.A4_WIDTH, page.getStringProperty( MasterPage.WIDTH_PROP ) );

			// undo it, type and height/width should recover.

			designHandle.getCommandStack( ).undo( );
			assertEquals( DesignChoiceConstants.PAGE_SIZE_CUSTOM, page
					.getStringProperty( MasterPage.TYPE_PROP ) ); //$NON-NLS-1$
			assertEquals( "12in", page.getStringProperty( MasterPage.HEIGHT_PROP ) ); //$NON-NLS-1$
			assertEquals( "10in", page.getStringProperty( MasterPage.WIDTH_PROP ) ); //$NON-NLS-1$

			// Set type to US Letter, height/width should also have been cleaned.
			page.setPageType( DesignChoiceConstants.PAGE_SIZE_US_LEGAL );
			assertEquals( DesignChoiceConstants.PAGE_SIZE_US_LEGAL, page
					.getStringProperty( MasterPage.TYPE_PROP ) ); //$NON-NLS-1$
			assertEquals( MasterPage.US_LEGAL_HEIGHT, page.getStringProperty( MasterPage.HEIGHT_PROP ) );
			assertEquals( MasterPage.US_LEGAL_WIDTH, page.getStringProperty( MasterPage.WIDTH_PROP ) );
		
		}
}
