package org.eclipse.birt.report.tests.model.smoke;

import java.util.Iterator;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.DesignChoiceConstants;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.interfaces.IStyleModel;
import org.eclipse.birt.report.model.metadata.ColorPropertyType;
import org.eclipse.birt.report.tests.model.BaseTestCase;


public class TableItemTest extends BaseTestCase
{

	public TableItemTest(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}

	 public static Test suite()
	    {
			
			return new TestSuite(TableItemTest.class);
		}
		protected void setUp( ) throws Exception
		{
			super.setUp( );
			openDesign( "TableItemTest.xml" ); //$NON-NLS-1$
		}
		
		public void testOperations( ) throws Exception
		{
			//Binding the table with a data set
			TableHandle table = (TableHandle)designHandle.findElement("MyTable");
			assertNotNull(table);
			DataSetHandle ds = designHandle.findDataSet("dset");
			assertNotNull(ds);
			table.setDataSet(ds);
			assertEquals("dset",table.getDataSet().getName());
		 
			//set sort key for table
			SortKey sortkey = StructureFactory.createSortKey( );
			sortkey.setKey( "row[\"ORDERDATE\"]" );
			sortkey.setDirection(DesignChoiceConstants.SORT_DIRECTION_DESC);
			PropertyHandle propHandle = table.getPropertyHandle( ListingElement.SORT_PROP );
			propHandle.addItem( sortkey );
			assertEquals("row[\"ORDERDATE\"]",sortkey.getKey());
			assertEquals(DesignChoiceConstants.SORT_DIRECTION_DESC,sortkey.getDirection());
			
			//set filter key for table
			propHandle = table.getPropertyHandle( ListingElement.FILTER_PROP );
			FilterCondition filter = StructureFactory.createFilterCond( );
			filter.setExpr( "row[\"ORDERNUMBER\"]" ); //$NON-NLS-1$
			filter.setOperator( DesignChoiceConstants.MAP_OPERATOR_BETWEEN );
			filter.setValue1( "10100" ); //$NON-NLS-1$
			filter.setValue2( "10200" ); 
			propHandle.addItem( filter );
			assertEquals("row[\"ORDERNUMBER\"]",filter.getExpr());
			assertEquals( DesignChoiceConstants.MAP_OPERATOR_BETWEEN, filter.getOperator( ) );
			assertEquals("10100",filter.getValue1());
			assertEquals("10200",filter.getValue2());
 
			//set group for table

			TableGroupHandle group = newTableGroup( 1, 1, 3 );
			group.setKeyExpr("row[\"ORDERDATE\"]");
			group.setInterval(DesignChoiceConstants.INTERVAL_YEAR);
			group.setIntervalRange(1);
			table.getGroups( ).add( group );
			assertEquals("row[\"ORDERDATE\"]",group.getKeyExpr());
			assertEquals(DesignChoiceConstants.INTERVAL_YEAR,group.getInterval());
			assertEquals(1,group.getIntervalRange(), 0);
			
            //set the color of the first column as blue

			table.getColumns( ).get( 0 ).setProperty( IStyleModel.COLOR_PROP,
					ColorPropertyType.BLUE );

			CellHandle cell = (CellHandle) ( (RowHandle) group.getHeader( )
					.get( 0 ) ).getCells( ).get( 0 );
			assertEquals( ColorPropertyType.BLUE, cell
					.getProperty( IStyleModel.COLOR_PROP ) );
			
				
			//set highlight for table
			propHandle = table.getPropertyHandle(IStyleModel.HIGHLIGHT_RULES_PROP );
			HighlightRule highlight = StructureFactory.createHighlightRule();
			highlight.setTestExpression("row[\"ORDERNUMBER\"]");
			highlight.setOperator(DesignChoiceConstants.MAP_OPERATOR_EQ);
			highlight.setValue1("10101");
			assertEquals("row[\"ORDERNUMBER\"]",highlight.getTestExpression());
			assertEquals(DesignChoiceConstants.MAP_OPERATOR_EQ,highlight.getOperator());
			assertEquals("10101",highlight.getValue1());
			propHandle.addItem(highlight);
			
		}
		public void testProperties( ) throws Exception
		{
			//properties on table item, table columns, table rows and table cells
			TableHandle table = (TableHandle)designHandle.findElement("MyTable");
			assertNotNull(table);
			table.setProperty(IStyleModel.COLOR_PROP,ColorPropertyType.BLUE );
			CellHandle cell = (CellHandle) ( (RowHandle) table.getDetail().get( 0 ) ).getCells( ).get( 0 );
			assertEquals(ColorPropertyType.BLUE,cell.getProperty( IStyleModel.COLOR_PROP ));
			
			ColumnHandle column =(ColumnHandle)table.getColumns().get(1);
		    column.setProperty(IStyleModel.TEXT_ALIGN_PROP,DesignChoiceConstants.TEXT_ALIGN_CENTER);
		    cell = (CellHandle) ( (RowHandle) table.getHeader().get( 0 ) ).getCells( ).get(1);
		    assertEquals(DesignChoiceConstants.TEXT_ALIGN_CENTER,cell.getProperty(IStyleModel.TEXT_ALIGN_PROP));
		    
		    RowHandle row = (RowHandle)table.getFooter().get(0);
		    row.setProperty(IStyleModel.FONT_SIZE_PROP,DesignChoiceConstants.FONT_SIZE_LARGE);
			cell = (CellHandle) row.getCells( ).get(2);
			assertEquals(DesignChoiceConstants.FONT_SIZE_LARGE,cell.getProperty(IStyleModel.FONT_SIZE_PROP));
		}
		
		private TableGroupHandle newTableGroup( int headerRowNum, int footerRowNum,
				int columnNum ) throws SemanticException
		{
			assert headerRowNum > 0 && footerRowNum > 0 && columnNum > 0;
			TableGroupHandle group = designHandle.getElementFactory( )
					.newTableGroup( );

			for ( int i = 0; i < headerRowNum; i++ )
				group.getHeader( ).add(
						designHandle.getElementFactory( ).newTableRow( columnNum ) );

			for ( int i = 0; i < footerRowNum; i++ )
				group.getFooter( ).add(
						designHandle.getElementFactory( ).newTableRow( columnNum ) );

			return group;
		}
		
}

