package org.eclipse.birt.report.tests.model.smoke;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;



public class TextElementHandleTest extends BaseTestCase
{
	String fileName = "BlankReport.xml";
	private String outFileName = "TextElementHandleDpt.xml"; 
	private String goldenFileName = "TextElementHandleDpt_golden.xml"; 
	String TempFile= getClassFolder() + OUTPUT_FOLDER + outFileName;
	
	public TextElementHandleTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(TextElementHandleTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testTextElement( ) throws Exception
	{
		openDesign(fileName);
		
//		New a text without name.
		TextItemHandle textHandle = (TextItemHandle)designHandle.getElementFactory().newTextItem( "" );
		designHandle.getBody().add( textHandle );
		
//		Set the text name
	    textHandle.setName( "myText" );
	    assertEquals( "myText",  textHandle.getName() );
	    
//	    Set the text content type
	    textHandle.setContentType( "html" );
	    assertEquals( "html" , textHandle.getContentType() );
	    
//	    Set the text content
	    textHandle.setContent( "Text1" );
	    assertEquals( "Text1" , textHandle.getContent() );
	    
//	    Set the text font family
	    textHandle.setProperty( StyleHandle.FONT_FAMILY_PROP , "Sans Serif" );
	    assertEquals( "sans-serif" , textHandle.getStringProperty( "fontFamily" ));
	    
//	    Set the text color
	    textHandle.setProperty( StyleHandle.COLOR_PROP , "Blue" );
	    assertEquals( "blue" , textHandle.getStringProperty("color") );
	    
//	    Set the text align
	    textHandle.setProperty( StyleHandle.TEXT_ALIGN_PROP , "Right" );
	    assertEquals( "right" , textHandle.getStringProperty("textAlign") );
	    
//	    Set the line fo through
		textHandle.setProperty( StyleHandle.TEXT_LINE_THROUGH_PROP , "line-through" );
		assertEquals( "line-through" , textHandle.getStringProperty( "textLineThrough" ) );
		
//		Set the under line
		textHandle.setProperty( StyleHandle.TEXT_UNDERLINE_PROP , "underline" );
		assertEquals( "underline" , textHandle.getStringProperty( "textUnderline" ) );
	    
//		Set the text high
	    textHandle.setHeight( "100pt" );
	    assertEquals( "100pt" , textHandle.getHeight().getStringValue() );
	    
//	    Set the font size
		textHandle.setProperty( StyleHandle.FONT_SIZE_PROP, "10pt" );
		assertEquals( "10pt" , textHandle.getStringProperty( "fontSize" ) );
		
//		Set the font weight
		textHandle.setProperty( StyleHandle.FONT_WEIGHT_PROP, "bold" );
		assertEquals( "bold" , textHandle.getStringProperty("fontWeight") );
		
//		Set the font style
		textHandle.setProperty( StyleHandle.FONT_STYLE_PROP, "italic");
    	assertEquals( "italic" , textHandle.getStringProperty("fontStyle") );

//    	Set the text background color
		textHandle.setProperty( StyleHandle.BACKGROUND_COLOR_PROP, "Red" );
		assertEquals( "red" , textHandle.getStringProperty( "backgroundColor" ) );
		
//		Set border bottom color
		textHandle.setProperty( StyleHandle.BORDER_BOTTOM_COLOR_PROP, "Blue" );
		assertEquals( "blue" , textHandle.getStringProperty( "borderBottomColor" ) );
		
//		Set border bottom width
		textHandle.setProperty( StyleHandle.BORDER_BOTTOM_WIDTH_PROP, "10pt" );
		assertEquals( "10pt" , textHandle.getStringProperty( "borderBottomWidth" ) );
		
//		Set border left color
		textHandle.setProperty( StyleHandle.BORDER_LEFT_COLOR_PROP, "Green" );
		assertEquals( "green" , textHandle.getStringProperty( "borderLeftColor" ) );
		
//		Set border left width
		textHandle.setProperty( StyleHandle.BORDER_LEFT_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , textHandle.getStringProperty( "borderLeftWidth" ) );
		
//		Set border right color
        textHandle.setProperty( StyleHandle.BORDER_RIGHT_COLOR_PROP, "Yellow" );
        assertEquals( "yellow" , textHandle.getStringProperty( "borderRightColor" ) );
		
//      Set border right width
		textHandle.setProperty( StyleHandle.BORDER_RIGHT_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , textHandle.getStringProperty( "borderRightWidth" ) );
		
//		Set border top color
        textHandle.setProperty( StyleHandle.BORDER_TOP_COLOR_PROP, "White" );
        assertEquals( "white" , textHandle.getStringProperty( "borderTopColor" ) );
		
//        Set border top width
		textHandle.setProperty( StyleHandle.BORDER_TOP_WIDTH_PROP, "10pt");
		assertEquals( "10pt" , textHandle.getStringProperty( "borderTopWidth" ) );
		
//		Set magin bottom
		textHandle.setProperty( StyleHandle.MARGIN_BOTTOM_PROP, "5pt" );
		assertEquals( "5pt" , textHandle.getStringProperty( "marginBottom" ) );
		
//		Set magin top
		textHandle.setProperty( StyleHandle.MARGIN_TOP_PROP, "5pt" );
		assertEquals( "5pt" , textHandle.getStringProperty( "marginTop" ) );
		
//		Set magin right
		textHandle.setProperty( StyleHandle.MARGIN_RIGHT_PROP, "5pt" );
		assertEquals( "5pt" , textHandle.getStringProperty( "marginRight" ) );
		
//		Set magin left
		textHandle.setProperty( StyleHandle.MARGIN_LEFT_PROP, "5pt" );
		assertEquals( "5pt" , textHandle.getStringProperty( "marginLeft" ) );
		
//		Setpadding bottom
		textHandle.setProperty( StyleHandle.PADDING_BOTTOM_PROP, "8pt" );
		assertEquals( "8pt" , textHandle.getStringProperty( "paddingBottom" ) );
		
//		Setpadding left
		textHandle.setProperty( StyleHandle.PADDING_LEFT_PROP, "8pt" );
		assertEquals( "8pt" , textHandle.getStringProperty( "paddingLeft" ) );
		
//		Setpadding right
		textHandle.setProperty( StyleHandle.PADDING_RIGHT_PROP, "8pt" );		
		assertEquals( "8pt" , textHandle.getStringProperty( "paddingRight" ) );
		
//		Setpadding top
		textHandle.setProperty( StyleHandle.PADDING_TOP_PROP, "8pt" );
		assertEquals( "8pt" , textHandle.getStringProperty( "paddingTop" ) );
		
//		Set page break before
		textHandle.setProperty( StyleHandle.PAGE_BREAK_BEFORE_PROP, "avoid" );
		assertEquals( "avoid", textHandle.getStringProperty( "pageBreakBefore" ) );
		
//		Set page break after
		textHandle.setProperty( StyleHandle.PAGE_BREAK_AFTER_PROP, "Always" );
		assertEquals( "always", textHandle.getStringProperty( "pageBreakAfter" ) );	
		
		
		designHandle.saveAs( TempFile );
		assertTrue( compareTextFile( goldenFileName, outFileName ) );
		}
}
