
package org.eclipse.birt.test.performance;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
 * Configuration - initialize config. variables of this test suite
 */
public class Configuration
{

	/**
	 * number of threads
	 */
	public static int tCount;

	/**
	 * number of reports
	 */
	public static int rCount;

	/**
	 * report format
	 */
	public static String format;

	/**
	 * report locale
	 */
	public static String locale;

	/**
	 * report encoding
	 */
	public static String encoding;

	/**
	 * input string, e.g. testA.rptdesign
	 */
	public static List input;

	/**
	 * output string, e.g. testA
	 */
	public static List output;

	/**
	 * used to store design=pageN pairs parsed from config. profile
	 */
	public static HashMap designs;

	/**
	 * parseFile, parse config. profile
	 * 
	 * @param basePath -
	 *            base path to locate config. profile
	 * @param fileName -
	 *            config. profile
	 */
	public static void parseFile( String basePath, String fileName )
			throws Exception
	{

		try
		{
			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance( );
			DocumentBuilder builder = factory.newDocumentBuilder( );
			File configXML = new File( basePath + fileName );
			if ( configXML.exists( ) )
			{
				Document document = builder.parse( configXML );
				NodeList root = document.getElementsByTagName( "TestSuite" ); //$NON-NLS-1$
				// there will be only one TestSuite element
				for ( int x = 0; x < root.getLength( ); x++ )
				{
					Element element = (Element) root.item( x );
					// parse threads element
					Element threadsTag = (Element) element
							.getElementsByTagName( "threads" ).item( 0 ); //$NON-NLS-1$
					String threadsCount = ( (Text) threadsTag.getFirstChild( ) )
							.getData( );
					tCount = Integer.parseInt( threadsCount );
					// parse reports element
					Element reportsTag = (Element) element
							.getElementsByTagName( "reports" ).item( 0 ); //$NON-NLS-1$
					String reportsCount = ( (Text) reportsTag.getFirstChild( ) )
							.getData( );
					rCount = Integer.parseInt( reportsCount );
					// parse format element
					Element formatTag = (Element) element.getElementsByTagName(
							"format" ).item( 0 ); //$NON-NLS-1$
					format = ( (Text) formatTag.getFirstChild( ) ).getData( );
					// parse locale element
					Element localeTag = (Element) element.getElementsByTagName(
							"locale" ).item( 0 ); //$NON-NLS-1$
					locale = ( (Text) localeTag.getFirstChild( ) ).getData( );
					// parse encoding element
					Element encodingTag = (Element) element
							.getElementsByTagName( "encoding" ).item( 0 ); //$NON-NLS-1$
					encoding = ( (Text) encodingTag.getFirstChild( ) )
							.getData( );
					// parse designs element
					Element designsTag = (Element) element
							.getElementsByTagName( "designs" ).item( 0 ); //$NON-NLS-1$
					// parse design attribute
					input = new ArrayList( rCount );
					output = new ArrayList( rCount );
					designs = new HashMap( );
					for ( int y = 0; y < rCount; y++ )
					{
						Element designTag = (Element) designsTag
								.getElementsByTagName( "design" ).item( y ); //$NON-NLS-1$
						String inputStr = designTag.getAttribute( "design" ); //$NON-NLS-1$
						int dotIndex = inputStr.lastIndexOf( "." ); //$NON-NLS-1$
						String outputStr = inputStr.substring( 0, dotIndex );
						input.add( inputStr );
						output.add( outputStr );
						String pageN = designTag.getAttribute( "pageN" ); //$NON-NLS-1$
						designs.put( outputStr, pageN );
					}
				}
				// sort input and output
				Collections.sort( input );
				Collections.sort( output );
			}
			else
			{
				throw new Exception( configXML + " not found" ); //$NON-NLS-1$
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace( );
			System.exit( -1 );
		}
	}

	/**
	 * get page no., it is either 1st or Nth
	 * 
	 * @param design -
	 *            report design
	 */
	public static int getPageN( String design )
	{

		String pageN = (String) designs.get( design );
		return Integer.parseInt( pageN );
	}
	
	/**
	 * reset, reset config. variables
	 */
	public static void resetConfig( )
	{
		
		tCount = 0;
		rCount = 0;
		format = "";
		locale = "";
		encoding = "";
		input = null;
		output = null;
		designs = null;
	}
}