
package org.eclipse.birt.test.performance;

/**
 * Execution - provide entry point to this test suite
 */
public class Execution
{

	/**
	 * Entry point method for Java App.
	 * 
	 * @param args -
	 *            args
	 */
	public static void main( String[] args )
	{
		
		for ( int i = 0; i < args.length; i++ )
		{
			if ( args[i].equals( "executeOne") )
			{
				// run Java App. ( mode = 0 )
				// execute one case (user-defined)

				Scheduler scheduler = new Scheduler( 0, Constants.CONFIG );
				scheduler.runWarmUp( );
				scheduler.runTasks( );
			}
			if ( args[i].equals( "executeAll") )
			{
				// run Java App. ( mode = 0 )
				// execute all cases (pre-defined)
				try
				{
					Scheduler scheduler1 = new Scheduler( 0, Constants.CASE_1THREAD_PDF );
					scheduler1.runWarmUp( );
					scheduler1.runTasks( );
					
					Scheduler scheduler2 = new Scheduler( 0, Constants.CASE_10THREADS_PDF );
					scheduler2.runWarmUp( );
					scheduler2.runTasks( );

					Scheduler scheduler3 = new Scheduler( 0, Constants.CASE_10THREADS_HTML );
					scheduler3.runWarmUp( );
					scheduler3.runTasks( );

					Scheduler scheduler4 = new Scheduler( 0, Constants.CASE_1THREAD_HTML );
					scheduler4.runWarmUp( );
					scheduler4.runTasks( );									
				}
				catch ( Exception e )
				{
					e.printStackTrace( );
					System.exit( -1 );
				}
			}
		}
	}

	/**
	 * Entry point method for Eclipse App.
	 * 
	 * @param args -
	 *            args
	 */
	public static void execute( String[] args )
	{
		for ( int i = 0; i < args.length; i++ )
		{
			if ( args[i].equals( "executeOne") )
			{
				// run Eclipse App. ( mode = 1 )
				// execute one case (user-defined)
		
				Scheduler scheduler = new Scheduler( 1, Constants.CONFIG );
				scheduler.runWarmUp( );
				scheduler.runTasks( );
			}
			if ( args[i].equals( "executeAll") )
			{
				// run Eclipse App. ( mode = 1 )
				// execute all cases (pre-defined)
			
				try
				{
					Scheduler scheduler1 = new Scheduler( 1, Constants.CASE_1THREAD_PDF );
					scheduler1.runWarmUp( );
					scheduler1.runTasks( );

					Scheduler scheduler2 = new Scheduler( 1, Constants.CASE_10THREADS_PDF );
					scheduler2.runWarmUp( );
					scheduler2.runTasks( );

					Scheduler scheduler3 = new Scheduler( 1, Constants.CASE_10THREADS_HTML );
					scheduler3.runWarmUp( );
					scheduler3.runTasks( );

					Scheduler scheduler4 = new Scheduler( 1, Constants.CASE_1THREAD_HTML );
					scheduler4.runWarmUp( );
					scheduler4.runTasks( );				
				}
				catch ( Exception e )
				{
					e.printStackTrace( );
					System.exit( -1 );
				}
			}
		}
	}
}