
package org.eclipse.birt.test.performance;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOptionBase;

/**
 * RunRenderThread - represent a thread to perform engine RunRender task
 */
public class RunRenderThread extends Thread
{

	public static int rCount;
	public static String format;
	public static String locale;
	public static String encoding;
	public static List input;
	public static List output;
	public static IReportEngine engine;
	public static Map stats;

	private Semaphore semaphore;
	private String basePath;

	/**
	 * Constructor
	 * 
	 * @param threadName -
	 *            thread identifier, use to identify this thread
	 * @param semaphore -
	 *            semaphore instance, use to call back thread monitor
	 * @param basePath -
	 *            configured basePath to input and output folder
	 */
	public RunRenderThread( String threadName, Semaphore semaphore,
			String basePath )
	{

		super( threadName );
		this.semaphore = semaphore;
		this.basePath = basePath;
	}

	public void run( )
	{

		try
		{
			long bTime;
			long eTime;

			for ( int i = 0; i < rCount; i++ )
			{
				// execution, task begin
				String inputStr = input.get( i ).toString( );
				String outputStr = output.get( i ).toString( );
				System.out.println( "begin " + inputStr ); //$NON-NLS-1$
				bTime = System.currentTimeMillis( );

				IReportRunnable runnable = engine.openReportDesign( basePath
						+ Constants.INPUT_PATH + inputStr );
				IRunAndRenderTask task = engine
						.createRunAndRenderTask( runnable );
				task.setLocale( getLocale( locale ) );

				IRenderOption options = null;
				if ( format.equalsIgnoreCase( "pdf" ) ) //$NON-NLS-1$
				{
					options = new RenderOptionBase( );
					String outputFile = basePath + Constants.RUNRENDER_PATH
							+ outputStr + this.getName( ) + Constants.PDF_EXT;
					options.setOutputFileName( outputFile );
				}
				else
				{
					options = new HTMLRenderOption( );
					String outputFile = basePath + Constants.RUNRENDER_PATH
							+ outputStr + this.getName( ) + Constants.HTML_EXT;
					options.setOutputFileName( outputFile );

					HTMLRenderContext renderContext = new HTMLRenderContext( );
					renderContext.setImageDirectory( "image" ); //$NON-NLS-1$
					HashMap appContext = new HashMap( );
					appContext.put(
							EngineConstants.APPCONTEXT_HTML_RENDER_CONTEXT,
							renderContext );
					task.setAppContext( appContext );
				}
				options.setOutputFormat( format );
				options.getOutputSetting( ).put( HTMLRenderOption.URL_ENCODING,
						encoding );

				task.setRenderOption( options );
				task.run( );
				task.close( );

				// execution, task end
				eTime = System.currentTimeMillis( );
				System.out.println( "end " + inputStr ); //$NON-NLS-1$

				// record task time
				if ( stats != null )
				{
					stats.put( outputStr + "[thread" + this.getName( ) + "]", //$NON-NLS-1$//$NON-NLS-2$
							new Long( eTime - bTime ) );
				}
			}
			// stop semaphore
			semaphore.release( );
		}
		catch ( Exception e )
		{
			e.printStackTrace( );
			System.exit( -1 );
		}
	}

	// get locale
	private Locale getLocale( String locale )
	{

		int i = locale.indexOf( '_' );
		if ( i != -1 )
		{
			// e.g., en_US
			String language = locale.substring( 0, i );
			String country = locale.substring( i + 1 );
			return new Locale( language, country );
		}
		// e.g., en
		return new Locale( locale );
	}
}