
package org.eclipse.birt.test.performance;

/**
 * Semaphore - utility class that allows threads to use "signal" to inform
 * thread monitor of their status
 */
public class Semaphore
{

	private int count;

	public Semaphore( int count )
	{

		this.count = count;
	}

	/**
	 * re-set semaphore counter
	 */
	public synchronized void reset( )
	{

		this.count = 0;
	}

	/**
	 * increase semaphore counter
	 */
	public synchronized void acquire( )
	{

		count++;
	}

	/**
	 * holdup semaphore, i.e. "sleep signal"
	 */
	public synchronized void holdup( )
	{

		try
		{
			while ( count > 0 )
			{
				this.wait( );
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace( );
			System.exit( -1 );
		}
	}

	/**
	 * release semaphore, i.e. "wakeup signal"
	 */
	public synchronized void release( )
	{

		count--;
		try
		{
			this.notify( );
		}
		catch ( Exception e )
		{
			e.printStackTrace( );
			System.exit( -1 );
		}
	}
}