/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.acceptance;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;

import testutil.APITestCase;
import testutil.ConfigText;
import testutil.APITestCase.DataSourceInfo;

/**
 * Test feature of ColumnHint
 */
public class ColumnAliasTest extends APITestCase
{

	private String tableCalls;
	private String tableCustomer;

	/*
	 * @see org.eclipse.birt.data.engine.api.APITestCase#setUp()
	 */
	protected void setUp( ) throws Exception
	{
		super.setUp( );

		prepareDataSet( new DataSourceInfo( ConfigText
				.getString( "Api.TestDataCalls.TableName" ), ConfigText
				.getString( "Api.TestDataCalls.TableSQL" ), ConfigText
				.getString( "Api.TestDataCalls.TestDataFileName" ) ) );

		tableCalls = ConfigText.getString( "Api.TestDataCalls.TableName" );
		tableCustomer = ConfigText.getString( "Api.TestDataCustomer.TableName" );
	}

	/*
	 * @see org.eclipse.birt.data.engine.api.APITestCase#getDataSourceInfo()
	 */
	protected DataSourceInfo getDataSourceInfo( )
	{
		return new DataSourceInfo( ConfigText
				.getString( "Api.TestDataCustomer.TableName" ), ConfigText
				.getString( "Api.TestDataCustomer.TableSQL" ), ConfigText
				.getString( "Api.TestDataCustomer.TestDataFileName" ) );
	}

	/**
	 * Test feature of duplicate column name from different tables
	 */
	public void testDuplicateColName( ) throws Exception
	{

		String testSQL = "select " + tableCalls + ".CustomerID, "
				+ tableCustomer + ".CustomerID, Charge from " + tableCalls
				+ ", " + tableCustomer;

		( (OdaDataSetDesign) this.dataSet ).setQueryText( testSQL );

		ColumnDefinition colDef = new ColumnDefinition( "CustomerID" );
		colDef.setAlias( "a" );
		colDef.setDataType( 0 );
		colDef.setExportHint( 2 );
		colDef.setColumnPosition( 2 );
		colDef.setSearchHint( 1 );

		this.dataSet.addResultSetHint( colDef );
		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row.CustomerID", 0 ),
				new ScriptExpression( "row.a", 0 ),
				new ScriptExpression( "row.Charge", 0 )};

		String names[] = { "COL_CUSTOMERID", "COL_A", "COL_CHARGE"};

		// define a query design
		QueryDefinition queryDefn = newReportQuery( );

		for ( int i = 0; i < expressions.length; i++ )
			queryDefn.addResultSetExpression( names[i], expressions[i] );

		IPreparedQuery preparedQuery = dataEngine.prepare( queryDefn );
		IQueryResults queryResults = preparedQuery.execute( null );
		IResultIterator resultIt = queryResults.getResultIterator( );

		outputQueryResult( resultIt, names );
		checkOutputFile( );	
	}
}
