/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.acceptance;

import org.eclipse.birt.data.engine.api.querydefn.BaseTransform;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
// import org.eclipse.birt.data.engine.api.APITestCase;
import testutil.APITestCase;
import testutil.ConfigText;

/**
 * DtE features test.
 */
public class FilterTest extends APITestCase
{

	/*
	 * @see org.eclipse.birt.data.engine.api.APITestCase#getDataSourceInfo()
	 */
	protected DataSourceInfo getDataSourceInfo( )
	{
		return new DataSourceInfo( ConfigText
				.getString( "Api.TestData.TableName" ), ConfigText
				.getString( "Api.TestData.TableSQL" ), ConfigText
				.getString( "Api.TestData.TestDataFileName" ) );
	}

	/**
	 * Test Integer input parameter is supported if set it in data set dialog
	 * and check all the data which are qualified will list in preview tab
	 */
	public void test1( ) throws Exception
	{

		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row.COUNTRY", 0 ),
				new ScriptExpression( "row.CITY", 0 ),
				new ScriptExpression( "row.SALE_DATE", 0 ),
				new ScriptExpression( "row.AMOUNT", 0 )};
		FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition(
				new ScriptExpression( "row.AMOUNT > 500" ) )};

		createAndRunQuery( expressions, filters );
		checkOutputFile( );
	}

	/**
	 * Test String input parameter is supported if set it in data set dialog and
	 * check all the data which are qualified will list in preview tab
	 */
	public void test2( ) throws Exception
	{

		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row.COUNTRY", 0 ),
				new ScriptExpression( "row.CITY", 0 ),
				new ScriptExpression( "row.SALE_DATE", 0 ),
				new ScriptExpression( "row.AMOUNT", 0 )};
		FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition(
				new ScriptExpression( "row.CITY == 'Chicago'" ) )};

		createAndRunQuery( expressions, filters );
		checkOutputFile( );
	}

	/**
	 * Test Large than operator is supported by string type filter and check all
	 * the data which are qualified will list in preview tab
	 */
	public void test3( ) throws Exception
	{

		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row.COUNTRY", 0 ),
				new ScriptExpression( "row.CITY", 0 ),
				new ScriptExpression( "row.SALE_DATE", 0 ),
				new ScriptExpression( "row.AMOUNT", 0 )};
		FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition(
				new ConditionalExpression( "row.CITY",
						ConditionalExpression.OP_GE, "'New York'" ) )};

		createAndRunQuery( expressions, filters );
		checkOutputFile( );
	}

	/**
	 * Test NOT_NULL is supported by string type filter and check all the data
	 * which are qualified will list in preview tab
	 */
	public void test4( ) throws Exception
	{

		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row.COUNTRY", 0 ),
				new ScriptExpression( "row.CITY", 0 ),
				new ScriptExpression( "row.SALE_DATE", 0 ),
				new ScriptExpression( "row.AMOUNT", 0 )};
		FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition(
				new ConditionalExpression( "row.CITY",
						ConditionalExpression.OP_NOT_NULL ) )};

		createAndRunQuery( expressions, filters );
		checkOutputFile( );
	}

	public void test5( ) throws Exception
	{

		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row.COUNTRY", 0 ),
				new ScriptExpression( "row.CITY", 0 ),
				new ScriptExpression( "row.SALE_DATE", 0 ),
				new ScriptExpression( "row.AMOUNT", 0 )};
		FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition(
				new ConditionalExpression( "row.SALE_DATE",
						ConditionalExpression.OP_GE,
						"'May 10, 2004 12:00:00 PM'" ) )};

		createAndRunQuery( expressions, filters );
		checkOutputFile( );
	}

	/**
	 * Create query definition from passed parameteres and then run it.
	 * 
	 * @param expressions
	 * @param groupDefn
	 * @param sortDefn
	 * @param filters
	 * @throws Exception
	 */
	private void createAndRunQuery( IBaseExpression[] expressions,

	FilterDefinition[] filters ) throws Exception
	{
		QueryDefinition queryDefn = createQueryDefn( expressions, filters );

		IPreparedQuery preparedQuery = dataEngine.prepare( queryDefn );
		IQueryResults queryResults = preparedQuery.execute( null );
		IResultIterator it = queryResults.getResultIterator( );
		outputQueryResult( it, new String[]{"COL_COUNTRY", "COL_CITY",
				"COL_SALE_DATE", "COL_AMOUNT"} );
	}

	/**
	 * Create query definition from passed parameters
	 * 
	 * @param expressions
	 *            row expression
	 * @param groupDefn
	 * @param sortDefn
	 * @param filters
	 * @return QueryDefinition
	 */
	private QueryDefinition createQueryDefn( IBaseExpression[] expressions,
			FilterDefinition[] filters )
	{
		// define a query design
		QueryDefinition queryDefn = newReportQuery( );

		if ( expressions != null )
			for ( int i = 0; i < expressions.length; i++ )
				queryDefn.addResultSetExpression( expressions[i].toString( ),
						expressions[i] );
		if ( filters != null )
			for ( int i = 0; i < filters.length; i++ )
				queryDefn.addFilter( filters[i] );

		return queryDefn;
	}

}