package org.eclipse.birt.tests.data.engine.acceptance;

import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;

import testutil.APITestCase;
import testutil.ConfigText;
import testutil.APITestCase.DataSourceInfo;

public class ParameterInt extends APITestCase {
	
	public BaseExpression expressions;
	/*
	 * @see org.eclipse.birt.data.engine.api.APITestCase#getDataSourceInfo()
	 */
	protected DataSourceInfo getDataSourceInfo( )
	{
		return new DataSourceInfo( ConfigText.getString( "Api.TestData.TableName" ),
				ConfigText.getString( "Api.TestData.TableSQL" ),
				ConfigText.getString( "Api.TestData.TestDataFileName" ) );
	}
	
	
	/**
	 * filter on date time with not between operator 
	 * 
	 * @throws Exception
	 */
	public void testFilterNotBetween( ) throws Exception
	{
		BaseExpression[] expressions = new BaseExpression[]{
			new ScriptExpression("row.COUNTRY",0),
			new ScriptExpression("row.SALE_DATE",6)
		};
		FilterDefinition filterDefn = new FilterDefinition(
				new ConditionalExpression("row.SALE_DATE",ConditionalExpression.OP_NOT_BETWEEN,"'05/01/2004'","'06/01/2004'")				
				);
		QueryDefinition queryDefn = new QueryDefinition();
		
		queryDefn.setDataSetName( this.dataSet.getName( ) );

		queryDefn.addFilter( filterDefn );
		
		for (int i = 0;i < expressions.length;i++)
		{
			queryDefn.addResultSetExpression(expressions[i].toString( ),expressions[i]);
		}
		IPreparedQuery preparedQuery = dataEngine.prepare( queryDefn );
		IQueryResults queryResults = preparedQuery.execute(null);
		IResultIterator resultIt = queryResults.getResultIterator();
	
		outputQueryResult( resultIt, new String[]{"COL_COUNTRY", "COL_SALE_DATE"} );
		checkOutputFile();
		
		
	}
	
	/**
	 * parameter with greater than operator
	 * 
	 * @throws Exception
	 */
	public void testParamGreater( ) throws Exception
	{
		String testSql = "select COUNTRY,AMOUNT from " + getTestTableName( )+" where amount > ?"; 
		( (OdaDataSetDesign)this.dataSet ).setQueryText( testSql );
		
		
		ParameterDefinition paramDefn = new ParameterDefinition( );
		paramDefn.setInputMode(true);
		paramDefn.setName("param1");
		paramDefn.setPosition(1);
		paramDefn.setDefaultInputValue("1000");
		paramDefn.setType(2);
		((OdaDataSetDesign)this.dataSet).addParameter( paramDefn );
		
		BaseExpression[] expressions = new BaseExpression[]{
				new ScriptExpression("row.COUNTRY",0),
				new ScriptExpression("row.AMOUNT",0)
		};		
		QueryDefinition queryDefn = new QueryDefinition( );
		queryDefn.setDataSetName( this.dataSet.getName( ) );
		for (int i=0;i< expressions.length;i++)
		{
			queryDefn.addResultSetExpression(expressions[i].toString( ),expressions[i]);
		}
		
		IPreparedQuery preparedQuery = dataEngine.prepare(queryDefn);
		IQueryResults queryResults = preparedQuery.execute(null);
		IResultIterator resultIt = queryResults.getResultIterator();

		outputQueryResult( resultIt, new String[]{"COL_COUNTRY", "COL_AMOUNT"}  );
		checkOutputFile();                                            
		
	}
	


	/**
	 * filter on date time with not between operator 
	 * 
	 * @throws Exception
	 */
	public void testFilterInvalidExpre( ) throws Exception
	{
		BaseExpression[] expressions = new BaseExpression[]{
			new ScriptExpression("row.COUNTRY",0),
			new ScriptExpression("row.SALE_DATE",6)
		};
		FilterDefinition filterDefn = new FilterDefinition(
				new ConditionalExpression("row.SALE_DATE",ConditionalExpression.OP_NOT_BETWEEN,"'05/01/2004'","abcd")
				);
		
		QueryDefinition queryDefn = new QueryDefinition();
		
		queryDefn.setDataSetName( this.dataSet.getName( ) );

		queryDefn.addFilter( filterDefn );
		
		for (int i = 0;i < expressions.length;i++)
		{
			queryDefn.addResultSetExpression(expressions[i].toString( ), expressions[i]);
		}
		IPreparedQuery preparedQuery = dataEngine.prepare( queryDefn );
		try
		{
			IQueryResults queryResults = preparedQuery.execute(null);
			IResultIterator resultIt = queryResults.getResultIterator();
			fail("should throw out exception");
		}
		catch ( Exception e )
		{
			
		}
				
	}
	
}
