/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * Select value in list filter doesn't work correctly when expression in filter
 * is boolean type.
 * <p>
 * <b>Test description</b>
 * <p>
 * This test covers the execution of filter on the boolean date type

 */
public class Reg_101856 extends EngineCase {

	private final static String INPUT = "Regression_101856_Test.xml"; //$NON-NLS-1$

	private final static String GOLDEN = "Regression_101856_Test.html"; //$NON-NLS-1$

	private final static String OUTPUT = "Regression_101856_Test.html"; //$NON-NLS-1$


	/**
	 * @throws Exception
	 */

	public void test() throws Exception {
		runAndRender_HTML(INPUT, OUTPUT);
		assertTrue(compareHTML(GOLDEN, OUTPUT));
	}
}
