/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * GroupDefinition provided several group interval types, e.g. numeric_interval,
 * year_interval, day_interal, etc. When doing grouping, the key expression
 * value will be evaluated and analyzed to decide if a new group will be
 * created, in other words, all these are based on a value- calculation. But
 * there is another special case: User just want to use the Record Count to
 * control the grouping logic.
 * <p>
 * <b>Test description</b>
 * <p>
 * This test covers the execution of the grouping logic.

 */
public class Reg_102128 extends EngineCase {

	private final static String INPUT = "Reg_102128.xml"; //$NON-NLS-1$

	private final static String GOLDEN = "Reg_102128.html"; //$NON-NLS-1$

	private final static String OUTPUT = "Reg_102128.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test() throws Exception {
		runAndRender_HTML(INPUT, OUTPUT);
		assertTrue(compareHTML(GOLDEN, OUTPUT));
	}
}
