/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * Creating a group with a 1 week interval, I expected it to be based on 'true'
 * weeks rather than arbitrary start points.In other words, BIRT seems to simply
 * take the start date and increment it by 7 days... regardless what day of the
 * week they fall on.
 * <p>
 * <b>Test description</b>
 * <p>
 * Creating a group with a 1 week interval, this test case should group by the
 * ordinary week.

 */
public class Reg_103346 extends EngineCase {

	private final static String INPUT = "Reg_103346.xml"; //$NON-NLS-1$

	private final static String GOLDEN = "Reg_103346.html"; //$NON-NLS-1$

	private final static String OUTPUT = "Reg_103346.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test() throws Exception {
		runAndRender_HTML(INPUT, OUTPUT);
		assertTrue(compareHTML(GOLDEN, OUTPUT));
	}
}
