/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * Error message throws when using new Date("3/2/2005") as value in table
 * filter.
 * <p>
 * <b>Test description</b>
 * <p>
 * 1. New a datasource and a dataset containing datetime column. 2. Insert a
 * table and new a filter based on the datetime column. 3. In value1, input new
 * Date("..."). eg. new Date("3/2/2005") 4. Save and preview.

 */
public class Reg_114470 extends EngineCase {

	private final static String INPUT = "Reg_114470.xml"; //$NON-NLS-1$

	private final static String GOLDEN = "Reg_114470.html"; //$NON-NLS-1$

	private final static String OUTPUT = "Reg_114470.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test() throws Exception {
		runAndRender_HTML(INPUT, OUTPUT);
		assertTrue(compareHTML(GOLDEN, OUTPUT));
	}
}
