/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * Error message "filter expression is invalid" appears after setting multipass
 * filter in a table.
 * <p>
 * <b>Test report description</b>
 * <p>
 * 1. Add a table.
 * 2. Add a computed column "a", and its value is
 * "row["ID"]/Total.sum(row ["ID"])". 
 * 3. Add a group, set its group key as "a"
 * 4. Add a filter "a=2".

 */
public class Reg_115989 extends EngineCase {

	private final static String INPUT = "Reg_115989.xml"; //$NON-NLS-1$

	private final static String GOLDEN = "Reg_115989.html"; //$NON-NLS-1$

	private final static String OUTPUT = "Reg_115989.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test() throws Exception {
		runAndRender_HTML(INPUT, OUTPUT);
		assertTrue(compareHTML(GOLDEN, OUTPUT));
	}
}
