/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * In the design the data is grouped first on the ShipByDate, and then is
 * grouped according the Status (so Status is sorted alphabetically within each
 * ShipByDate). This doesnt work as expected when the ShipByDate is grouped by
 * interval (in attached example its grouped by month)
 * <p>
 * <b>Test description</b>
 * <p>
 * This test covers the group by ShipByDate rather than the month

 */
public class Reg_117641 extends EngineCase {

	private final static String INPUT = "Reg_117641.xml"; //$NON-NLS-1$

	private final static String GOLDEN = "Reg_117641.html"; //$NON-NLS-1$

	private final static String OUTPUT = "Reg_117641.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test() throws Exception {
		runAndRender_HTML(INPUT, OUTPUT);
		assertTrue(compareHTML(GOLDEN, OUTPUT));
	}
}
