/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * The parameters filter in Total.sum(expression[,filter][,group])can not be
 * work
 * <p>
 * <b>Test description</b>
 * <p>
 * New a datasource and a dataset, add two expression of
 * Total.sum(expression[,filter][,group]) on the table. *

 */
public class Reg_122066 extends EngineCase
{

	private final static String INPUT = "Reg_122066.xml"; //$NON-NLS-1$
	private final static String GOLDEN = "Reg_122066.html"; //$NON-NLS-1$
	private final static String OUTPUT = "Reg_122066.html"; //$NON-NLS-1$

	
	/**
	 * @throws Exception
	 */
	
	public void test( ) throws Exception
	{
		runAndRender_HTML( INPUT, OUTPUT );
		assertTrue( compareHTML( GOLDEN, OUTPUT ) );
	}
}
