/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;


/**
 * <b>Bug description</b>
 * <p>
 * Create an sfdata data source. Create a data set that includes just the
 * Customer table.
 * Edit the data set. Add the following to the end of the statement:WHERE custID = ?
 * <p>
 * <b>Test description</b>
 * <p>
 * This test is to test the dataset's query text supported the parameter

 */
public class Reg_76549 extends EngineCase
{

	private final static String INPUT = "Reg_76549.xml"; //$NON-NLS-1$
	private final static String GOLDEN = "Reg_76549.html"; //$NON-NLS-1$
	private final static String OUTPUT = "Reg_76549.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */
	
	public void test( ) throws Exception
	{
		runAndRender_HTML( INPUT, OUTPUT );
		assertTrue( compareHTML( GOLDEN, OUTPUT ) );
	}
}
