/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * Filter on date time field for flat file doesn't take effect
 * <p>
 * <b>Test description</b>
 * <p>
 * This test check the filter function on date time field for sample database

 */
public class Reg_79012 extends EngineCase {

	private final static String INPUT = "Reg_79012.xml"; //$NON-NLS-1$

	private final static String GOLDEN = "Reg_79012.html"; //$NON-NLS-1$

	private final static String OUTPUT = "Reg_79012.html"; //$NON-NLS-1$

	protected void setUp() throws Exception {
		super.setUp();
	}

	/**
	 * @throws Exception
	 */

	public void test() throws Exception {
		runAndRender_HTML(INPUT, OUTPUT);
		assertTrue(compareHTML(GOLDEN, OUTPUT));
	}
}
