/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.regression;

import org.eclipse.birt.tests.data.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * NPE throws out when preview an informix table.
 * <p>
 * <b>Test description</b>
 * <p>
 * This test covers connection to the informix data base and preview the informix table.

 */
public class Reg_79182 extends EngineCase {

	private final static String INPUT = "Reg_79182.xml"; //$NON-NLS-1$

	private final static String GOLDEN = "Reg_79182.html"; //$NON-NLS-1$

	private final static String OUTPUT = "Reg_79182.html"; //$NON-NLS-1$

	protected void setUp() throws Exception {
		super.setUp();
	}

	/**
	 * @throws Exception
	 */

	public void test() throws Exception {
		runAndRender_HTML(INPUT, OUTPUT);
		assertTrue(compareHTML(GOLDEN, OUTPUT));
	}
}
