/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.tests.data.engine.smoke;

import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;

import testutil.APITestCase;
import testutil.ConfigText;
import testutil.APITestCase.DataSourceInfo;

/**
 * DtE features test.
 */
public class DsComputeColumnTest extends APITestCase
{


	private IQueryDefinition queryDefinition;

	/** computed column name */
	private String[] ccName;

	/** computed column expression */
	private String[] ccExpr;

	protected DataSourceInfo getDataSourceInfo( )
	{
		return new DataSourceInfo( ConfigText.getString( "Api.TestData1.TableName" ),
				ConfigText.getString( "Api.TestData1.TableSQL" ),
				ConfigText.getString( "Api.TestData1.TestDataFileName" ) );
	}

	
	public void testCCExpr( ) throws Exception
	{
		
		ccName = new String[]{
				"testComputed1","testComputed2"
		};
		ccExpr = new String[]{
				"row.col0","row.col1"	
		};
		
		queryDefinition = getDefaultQueryDefn( dataSet.getName( ) );
		
//		computedColumn = new ComputedColumn( ccName[0], ccExpr[0],DataType.INTEGER_TYPE );
//		( (BaseDataSetDesign) this.dataSet ).addComputedColumn( computedColumn );
//		computedColumn1 = new ComputedColumn( ccName[1], ccExpr[1],DataType.INTEGER_TYPE );
//		( (BaseDataSetDesign) this.dataSet ).addComputedColumn( computedColumn1 );

		
		
		ScriptExpression expr1 = new ScriptExpression(ccExpr[0],DataType.INTEGER_TYPE);
		ScriptExpression expr2 = new ScriptExpression(ccExpr[1],DataType.INTEGER_TYPE);
				
		((QueryDefinition) queryDefinition).addResultSetExpression(expr1.toString( ),expr1);
		((QueryDefinition) queryDefinition).addResultSetExpression(expr2.toString( ),expr2);

		IResultIterator rsIterator = executeQuery(queryDefinition);
		rsIterator.next();
		assertNotNull(rsIterator.getValue(expr1.toString( )));
		assertNotNull(rsIterator.getValue(expr2.toString( )));
		
	}
}