/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.tests.data.engine.smoke;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;

import testutil.APITestCase;
import testutil.ConfigText;
import testutil.APITestCase.DataSourceInfo;

/**
 * DtE features test.
 */
public class DsFilterTest extends APITestCase
{

	/*
	 * @see org.eclipse.birt.data.engine.api.APITestCase#getDataSourceInfo()
	 */
	protected DataSourceInfo getDataSourceInfo( )
	{
		return new DataSourceInfo( ConfigText
				.getString( "Api.TestData.TableName" ), ConfigText
				.getString( "Api.TestData.TableSQL" ), ConfigText
				.getString( "Api.TestData.TestDataFileName" ) );
	}

	/**
	 * Test feature without any group, sort, filter
	 */
	public void test_SimpleExpression( ) throws Exception
	{
		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row.COUNTRY", 0 ),
				new ScriptExpression( "row.SALE_DATE", 0 ),
				new ScriptExpression( "row.AMOUNT", 0 )};
		createAndRunQuery( expressions, null, null, null );
		checkOutputFile( );
	}

	/**
	 * Test the feature of filter with larger than operator on integer field.
	 */
	public void test_FilterOnInteger( ) throws Exception
	{
		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row[0]", 0 ),
				new ScriptExpression( "row._rowPosition ", 0 ),
				new ScriptExpression( "row.COUNTRY", 5 ),
				new ScriptExpression( "row.CITY", 5 ),
				new ScriptExpression( "row.SALE_DATE", 6 ),
				new ScriptExpression( "row.AMOUNT", 2 )};
		FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition(
				new ScriptExpression( "row.AMOUNT > 700" ) )};

		createAndRunQuery( expressions, null, null, filters );
		checkOutputFile( );
	}

	/**
	 * Test the feature of filter on string type expression
	 */
	public void test_FilterOnString( ) throws Exception
	{
		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row[0]", 0 ),
				new ScriptExpression( "row._rowPosition ", 0 ),
				new ScriptExpression( "row.COUNTRY", 5 ),
				new ScriptExpression( "row.CITY", 5 ),
				new ScriptExpression( "row.SALE_DATE", 6 ),
				new ScriptExpression( "row.AMOUNT", 2 )};
		FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition(
				new ScriptExpression( "row.CITY == \"New York\" " ) )};

		createAndRunQuery( expressions, null, null, filters );
		checkOutputFile( );
	}

	/**
	 * Test the feature of filter with equal to operator on date time field.
	 */
	public void test_FilterOnDate( ) throws Exception
	{
		IBaseExpression[] expressions = new IBaseExpression[]{
				new ScriptExpression( "row[0]", 0 ),
				new ScriptExpression( "row._rowPosition ", 0 ),
				new ScriptExpression( "row.COUNTRY", 5 ),
				new ScriptExpression( "row.CITY", 5 ),
				new ScriptExpression( "row.SALE_DATE", 6 ),
				new ScriptExpression( "row.AMOUNT", 2 )};
		FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition(
				new ConditionalExpression( "row.SALE_DATE",
						ConditionalExpression.OP_GE, "'01/20/2004 00:00:00.0'" ) )};
		createAndRunQuery( expressions, null, null, filters );
		checkOutputFile( );
	}

	/**
	 * Create query definition from passed parameteres and then run it.
	 * 
	 * @param expressions
	 * @param groupDefn
	 * @param sortDefn
	 * @param filters
	 * @throws Exception
	 */
	private void createAndRunQuery( IBaseExpression[] expressions,
			GroupDefinition[] groupDefn, SortDefinition[] sortDefn,
			FilterDefinition[] filters ) throws Exception
	{
		QueryDefinition queryDefn = createQueryDefn( expressions, groupDefn,
				sortDefn, filters );
		
		IPreparedQuery preparedQuery = dataEngine.prepare( queryDefn );
		IQueryResults queryResults = preparedQuery.execute( jsScope );
		IResultIterator resultIt = queryResults.getResultIterator( );
		outputQueryResult( resultIt, new String[]{"COL_COUNTRY", "COL_CITY", "COL_SALE_DATE", "COL_AMOUNT"}  );
	}

	/**
	 * Create query definition from passed parameters
	 * 
	 * @param expressions
	 *            row expression
	 * @param groupDefn
	 * @param sortDefn
	 * @param filters
	 * @return QueryDefinition
	 */
	private QueryDefinition createQueryDefn( IBaseExpression[] expressions,
			GroupDefinition[] groupDefn, SortDefinition[] sortDefn,
			FilterDefinition[] filters )
	{
		// define a query design
		QueryDefinition queryDefn = newReportQuery( );

		if ( groupDefn != null )
			for ( int i = 0; i < groupDefn.length; i++ )
				queryDefn.addGroup( groupDefn[i] );
		if ( sortDefn != null )
			for ( int i = 0; i < sortDefn.length; i++ )
				queryDefn.addSort( sortDefn[i] );
		if ( expressions != null )
			for ( int i = 0; i < expressions.length; i++ )
				queryDefn.addResultSetExpression( expressions[i].toString( ),
						expressions[i] );
		if ( filters != null )
			for ( int i = 0; i < filters.length; i++ )
				queryDefn.addFilter( filters[i] );

		return queryDefn;
	}

}