/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExternalizedTextEditorDialog
extends TrayDialog
implements SelectionListener {
    private transient String sResult = "";
    private transient String sInputValue = "";
    private transient Button cbExternalize = null;
    private transient Combo cmbKeys = null;
    private transient Text txtValue = null;
    private transient Text txtCurrent = null;
    private transient List keys = null;
    private transient IUIServiceProvider serviceprovider = null;
    private String defaultValue;

    public ExternalizedTextEditorDialog(Shell parent, String sText, List keys, IUIServiceProvider serviceprovider, String defaultValue) {
        super(parent);
        this.sResult = sText;
        this.sInputValue = this.getValueComponent(sText);
        this.keys = keys;
        this.serviceprovider = serviceprovider;
        this.defaultValue = defaultValue;
    }

    public String getResult() {
        return this.sResult;
    }

    protected Control createContents(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.ExternalizeText_ID");
        this.getShell().setText(Messages.getString("ExternalizedTextEditorDialog.Title.ExternalizeText"));
        return super.createContents(parent);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 16;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        Composite cmpContent = new Composite(parent, 0);
        cmpContent.setLayout((Layout)glContent);
        cmpContent.setLayoutData((Object)new GridData(1808));
        this.cbExternalize = new Button(cmpContent, 32);
        GridData gdCBExternalize = new GridData(768);
        gdCBExternalize.horizontalSpan = 2;
        this.cbExternalize.setLayoutData((Object)gdCBExternalize);
        this.cbExternalize.setText(Messages.getString("ExternalizedTextEditorDialog.Lbl.ExternalizeText"));
        this.cbExternalize.addSelectionListener((SelectionListener)this);
        Label lblKey = new Label(cmpContent, 0);
        GridData gdLBLKey = new GridData();
        lblKey.setLayoutData((Object)gdLBLKey);
        lblKey.setText(Messages.getString("ExternalizedTextEditorDialog.Lbl.LookupKey"));
        this.cmbKeys = new Combo(cmpContent, 12);
        GridData gdCMBKeys = new GridData(768);
        this.cmbKeys.setLayoutData((Object)gdCMBKeys);
        this.cmbKeys.addSelectionListener((SelectionListener)this);
        GridLayout glCurrent = new GridLayout();
        glCurrent.horizontalSpacing = 5;
        glCurrent.verticalSpacing = 5;
        glCurrent.marginHeight = 0;
        glCurrent.marginWidth = 0;
        Composite cmpCurrent = new Composite(cmpContent, 0);
        GridData gdCMPCurrent = new GridData(1808);
        gdCMPCurrent.horizontalSpan = 2;
        cmpCurrent.setLayoutData((Object)gdCMPCurrent);
        cmpCurrent.setLayout((Layout)glCurrent);
        Label lblValue = new Label(cmpCurrent, 0);
        GridData gdLBLValue = new GridData(2);
        lblValue.setLayoutData((Object)gdLBLValue);
        lblValue.setText(Messages.getString("ExternalizedTextEditorDialog.Lbl.DefaultValue"));
        this.txtValue = new Text(cmpCurrent, 2882);
        GridData gdTXTValue = new GridData(1808);
        gdTXTValue.widthHint = 280;
        gdTXTValue.heightHint = 40;
        this.txtValue.setLayoutData((Object)gdTXTValue);
        GridLayout glExtValue = new GridLayout();
        glExtValue.horizontalSpacing = 5;
        glExtValue.verticalSpacing = 5;
        glExtValue.marginHeight = 0;
        glExtValue.marginWidth = 0;
        Composite cmpExtValue = new Composite(cmpContent, 0);
        GridData gdCMPExtValue = new GridData(1808);
        gdCMPExtValue.horizontalSpan = 2;
        cmpExtValue.setLayoutData((Object)gdCMPExtValue);
        cmpExtValue.setLayout((Layout)glExtValue);
        Label lblExtValue = new Label(cmpExtValue, 0);
        GridData gdLBLExtValue = new GridData(2);
        lblExtValue.setLayoutData((Object)gdLBLExtValue);
        lblExtValue.setText(Messages.getString("ExternalizedTextEditorDialog.Lbl.ExternalizedValue"));
        this.txtCurrent = new Text(cmpExtValue, 2890);
        GridData gdTXTCurrent = new GridData(1808);
        gdTXTCurrent.widthHint = 280;
        gdTXTCurrent.heightHint = 40;
        this.txtCurrent.setLayoutData((Object)gdTXTCurrent);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 2;
        glButtons.horizontalSpacing = 5;
        glButtons.verticalSpacing = 0;
        glButtons.marginWidth = 0;
        glButtons.marginHeight = 0;
        this.populateList();
        return cmpContent;
    }

    private void populateList() {
        if (this.keys.isEmpty()) {
            this.cbExternalize.setSelection(false);
            this.cbExternalize.setEnabled(false);
            this.cmbKeys.setEnabled(false);
        } else {
            Collections.sort(this.keys);
            this.cmbKeys.setItems(this.keys.toArray(new String[this.keys.size()]));
            String str = this.getKeyComponent(this.sResult);
            if (str != null && str.length() != 0) {
                this.cbExternalize.setSelection(true);
                this.cmbKeys.setEnabled(true);
                if (!this.keys.contains(str)) {
                    this.cmbKeys.add(str);
                    this.cmbKeys.select(this.cmbKeys.getItemCount() - 1);
                } else {
                    this.cmbKeys.setText(str);
                }
            } else {
                this.cbExternalize.setSelection(false);
                this.cmbKeys.setEnabled(false);
                this.cmbKeys.select(0);
            }
        }
        this.txtValue.setText(this.getDisplayValue());
        this.txtCurrent.setText(this.getCurrentPropertyValue());
    }

    private String getKeyComponent(String sText) {
        if (sText.indexOf("=") != -1) {
            return sText.substring(0, sText.indexOf("="));
        }
        return null;
    }

    private String getValueComponent(String sText) {
        String sKey = this.getKeyComponent(sText);
        if (sKey == null || "".equals(sKey) || this.serviceprovider == null) {
            if (sText.indexOf("=") != -1) {
                return sText.substring(sText.indexOf("=") + "=".length(), sText.length());
            }
            return sText;
        }
        String sValue = this.serviceprovider.getValue(sKey);
        if (sValue == null || "".equals(sValue)) {
            sValue = Messages.getString("ExternalizedTextEditorDialog.Warn.KeyNotFound");
        }
        return sValue;
    }

    private String getCurrentPropertyValue() {
        if (!this.cbExternalize.getSelection() || this.sResult == null || "".equals(this.sResult)) {
            return "";
        }
        return this.getValueComponent(this.sResult);
    }

    private String getDisplayValue() {
        if (this.cbExternalize.getSelection()) {
            if (this.defaultValue == null || this.defaultValue.length() == 0) {
                return new MessageFormat(Messages.getString("ExternalizedTextEditorDialog.Lbl.Value")).format(new Object[]{this.getKeyComponent(this.sResult)});
            }
            return this.defaultValue;
        }
        return this.getValueComponent(this.sResult);
    }

    private String buildString() {
        StringBuffer sbText = new StringBuffer("");
        String sKey = this.cmbKeys.getText();
        if (this.cbExternalize.getSelection()) {
            sbText.append(sKey);
            sbText.append("=");
        }
        sbText.append(this.txtValue.getText());
        return sbText.toString();
    }

    protected void okPressed() {
        this.sResult = this.buildString();
        super.okPressed();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cbExternalize)) {
            if (this.cbExternalize.getSelection()) {
                this.cmbKeys.setEnabled(true);
                if (this.cmbKeys.getItemCount() > 0) {
                    this.sResult = this.buildString();
                    this.txtValue.setText(this.getDisplayValue());
                    this.txtCurrent.setText(this.getCurrentPropertyValue());
                }
            } else {
                this.cmbKeys.setEnabled(false);
                this.txtValue.setText(this.sInputValue);
                this.txtCurrent.setText("");
            }
        } else if (e.getSource().equals(this.cmbKeys)) {
            this.sResult = this.buildString();
            this.txtValue.setText(this.getDisplayValue());
            this.txtCurrent.setText(this.getCurrentPropertyValue());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

