/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

class FillCanvas
extends Canvas
implements PaintListener {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.composites");
    Fill fCurrent = null;
    private boolean isAutoEnabled = false;

    public FillCanvas(Composite parent, int iStyle) {
        super(parent, iStyle);
        this.addPaintListener(this);
    }

    public FillCanvas(Composite parent, int iStyle, boolean isAutoEnabled) {
        this(parent, iStyle);
        this.isAutoEnabled = isAutoEnabled;
    }

    public void setFill(Fill fill) {
        this.fCurrent = fill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintControl(PaintEvent pe) {
        Color cBackground = null;
        try {
            Color clrTransparencyBackground = Display.getCurrent().getSystemColor(25);
            GC gc = pe.gc;
            if (!this.isEnabled()) {
                gc.setBackground(Display.getCurrent().getSystemColor(22));
                Color cFore = Display.getCurrent().getSystemColor(16);
                gc.setForeground(cFore);
                if (this.fCurrent == null || this.fCurrent instanceof ColorDefinition && ((ColorDefinition)this.fCurrent).getTransparency() == 0) {
                    gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
                    if (!this.isAutoEnabled || this.fCurrent != null) {
                        gc.drawText(Messages.getString("FillCanvas.Transparent"), 2, 2);
                    } else {
                        gc.drawText(Messages.getString("FillCanvas.Auto"), 2, 2);
                    }
                } else {
                    gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
                    gc.setBackground(cFore);
                    gc.fillRectangle(2, 2, this.getSize().x - 4, this.getSize().y - 4);
                }
            } else {
                if (this.fCurrent == null || this.fCurrent instanceof ColorDefinition && ((ColorDefinition)this.fCurrent).getTransparency() == 0) {
                    gc.setBackground(clrTransparencyBackground);
                    gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
                    Color cText = new Color((Device)this.getDisplay(), 0, 0, 0);
                    gc.setForeground(cText);
                    if (!this.isAutoEnabled || this.fCurrent != null) {
                        gc.drawText(Messages.getString("FillCanvas.Transparent"), 2, 2);
                    } else {
                        gc.drawText(Messages.getString("FillCanvas.Auto"), 2, 2);
                    }
                    cText.dispose();
                } else if (this.fCurrent instanceof ColorDefinition) {
                    cBackground = new Color((Device)Display.getDefault(), ((ColorDefinition)this.fCurrent).getRed(), ((ColorDefinition)this.fCurrent).getGreen(), ((ColorDefinition)this.fCurrent).getBlue());
                    gc.setBackground(cBackground);
                    gc.fillRectangle(2, 2, this.getSize().x - 4, this.getSize().y - 4);
                } else if (this.fCurrent instanceof Image) {
                    gc.fillRectangle(2, 2, this.getSize().x - 4, this.getSize().y - 4);
                    gc.drawImage(this.getSWTImage((Image)this.fCurrent), 2, 2);
                } else if (this.fCurrent instanceof Gradient) {
                    if (((Gradient)this.fCurrent).getStartColor() == null && ((Gradient)this.fCurrent).getEndColor() == null) {
                        return;
                    }
                    Color clrStart = null;
                    Color clrEnd = null;
                    if (((Gradient)this.fCurrent).getStartColor() != null) {
                        clrStart = new Color((Device)Display.getDefault(), ((Gradient)this.fCurrent).getStartColor().getRed(), ((Gradient)this.fCurrent).getStartColor().getGreen(), ((Gradient)this.fCurrent).getStartColor().getBlue());
                        gc.setForeground(clrStart);
                    }
                    if (((Gradient)this.fCurrent).getEndColor() != null) {
                        clrEnd = new Color((Device)Display.getDefault(), ((Gradient)this.fCurrent).getEndColor().getRed(), ((Gradient)this.fCurrent).getEndColor().getGreen(), ((Gradient)this.fCurrent).getEndColor().getBlue());
                        gc.setBackground(clrEnd);
                    }
                    gc.fillGradientRectangle(2, 2, this.getSize().x - 4, this.getSize().y - 4, false);
                }
                if (this.isFocusControl()) {
                    gc.setLineStyle(3);
                    gc.setForeground(Display.getCurrent().getSystemColor(2));
                    gc.drawRectangle(1, 1, this.getSize().x - 3, this.getSize().y - 3);
                }
            }
        }
        catch (Exception ex) {
            logger.log(ex);
        }
        finally {
            if (cBackground != null) {
                cBackground.dispose();
            }
        }
    }

    private org.eclipse.swt.graphics.Image getSWTImage(Image modelImage) {
        org.eclipse.swt.graphics.Image img = null;
        try {
            if (modelImage instanceof EmbeddedImage) {
                ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decodeBase64((byte[])((EmbeddedImage)modelImage).getData().getBytes()));
                img = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), (InputStream)bis);
            } else {
                try {
                    img = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), new URL(modelImage.getURL()).openStream());
                }
                catch (MalformedURLException e1) {
                    img = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(modelImage.getURL()));
                }
            }
        }
        catch (FileNotFoundException ex) {
            logger.log((Exception)ex);
            ex.printStackTrace();
        }
        catch (IOException ex) {
            logger.log((Exception)ex);
            ex.printStackTrace();
        }
        return img;
    }

    public void setEnabled(boolean bState) {
        super.setEnabled(bState);
        this.redraw();
    }
}

