/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.DateFormatDetail;
import org.eclipse.birt.chart.model.attribute.DateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.DateFormatType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.impl.FractionNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.NumberFormatSpecifierImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class FormatSpecifierComposite
extends Composite
implements SelectionListener {
    private transient Button btnUndefined = null;
    private transient Button btnStandard = null;
    private transient Button btnAdvanced = null;
    private transient Button btnFraction = null;
    private transient Combo cmbDataType = null;
    private transient Composite cmpStandardDetails = null;
    private transient StackLayout slStandardDetails = null;
    private transient Composite cmpStandardDateDetails = null;
    private transient Composite cmpStandardNumberDetails = null;
    private transient IFormatSpecifierUIComponent cpWrapStandardNumber = null;
    private transient IFormatSpecifierUIComponent cpWrapStandardDate = null;
    private transient IFormatSpecifierUIComponent cpWrapAdvancedNumber = null;
    private transient IFormatSpecifierUIComponent cpWrapAdvancedDate = null;
    private transient IFormatSpecifierUIComponent cpWrapFractionNumber = null;
    private transient Composite cmpAdvancedDetails = null;
    private transient StackLayout slAdvancedDetails = null;
    private transient Composite cmpAdvancedDateDetails = null;
    private transient Composite cmpAdvancedNumberDetails = null;
    private transient Composite cmpFractionNumberDetails = null;
    private transient FormatSpecifier formatspecifier = null;
    private transient boolean bEnableEvents = true;
    private static final int DATA_TYPE_NMUBER = 0;
    private static final int DATA_TYPE_DATETIME = 1;

    public FormatSpecifierComposite(Composite parent, int style, FormatSpecifier formatspecifier) {
        super(parent, style);
        this.formatspecifier = formatspecifier;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 0;
        this.slStandardDetails = new StackLayout();
        this.slAdvancedDetails = new StackLayout();
        this.setLayout((Layout)glContent);
        Label lblDataType = new Label((Composite)this, 0);
        GridData gdLBLDataType = new GridData();
        lblDataType.setLayoutData((Object)gdLBLDataType);
        lblDataType.setText(Messages.getString("FormatSpecifierComposite.Lbl.DataType"));
        this.cmbDataType = new Combo((Composite)this, 12);
        GridData gdCMBDataType = new GridData(768);
        this.cmbDataType.setLayoutData((Object)gdCMBDataType);
        this.cmbDataType.addSelectionListener((SelectionListener)this);
        this.btnUndefined = new Button((Composite)this, 16);
        GridData gdBTNUndefined = new GridData(768);
        gdBTNUndefined.horizontalSpan = 2;
        this.btnUndefined.setLayoutData((Object)gdBTNUndefined);
        this.btnUndefined.setText(Messages.getString("FormatSpecifierComposite.Lbl.Undefined"));
        this.btnUndefined.addSelectionListener((SelectionListener)this);
        Label lblDummyStandard = new Label((Composite)this, 0);
        GridData gdLBLDummyStandard = new GridData();
        gdLBLDummyStandard.horizontalSpan = 2;
        gdLBLDummyStandard.heightHint = 10;
        lblDummyStandard.setLayoutData((Object)gdLBLDummyStandard);
        this.btnStandard = new Button((Composite)this, 16);
        GridData gdBTNStandard = new GridData(768);
        gdBTNStandard.horizontalSpan = 2;
        this.btnStandard.setLayoutData((Object)gdBTNStandard);
        this.btnStandard.setText(Messages.getString("FormatSpecifierComposite.Lbl.Standard"));
        this.btnStandard.addSelectionListener((SelectionListener)this);
        this.cmpStandardDetails = new Composite((Composite)this, 0);
        GridData gdCMPStandardDetails = new GridData(1808);
        gdCMPStandardDetails.horizontalIndent = 16;
        gdCMPStandardDetails.horizontalSpan = 2;
        this.cmpStandardDetails.setLayoutData((Object)gdCMPStandardDetails);
        this.cmpStandardDetails.setLayout((Layout)this.slStandardDetails);
        this.cmpStandardDateDetails = new Composite(this.cmpStandardDetails, 0);
        GridLayout glDate = new GridLayout();
        glDate.verticalSpacing = 5;
        glDate.marginHeight = 0;
        glDate.marginWidth = 0;
        this.cmpStandardDateDetails.setLayout((Layout)glDate);
        this.cpWrapStandardDate = new DateStandardComposite(this.cmpStandardDateDetails);
        this.cmpStandardNumberDetails = new Composite(this.cmpStandardDetails, 0);
        GridLayout glNumber = new GridLayout();
        glNumber.verticalSpacing = 5;
        glNumber.marginHeight = 0;
        glNumber.marginWidth = 0;
        this.cmpStandardNumberDetails.setLayout((Layout)glNumber);
        this.cpWrapStandardNumber = new NumberStandardComposite(this.cmpStandardNumberDetails);
        Label lblDummyAdvanced = new Label((Composite)this, 0);
        GridData gdLBLDummyAdvanced = new GridData();
        gdLBLDummyAdvanced.horizontalSpan = 2;
        gdLBLDummyAdvanced.heightHint = 10;
        lblDummyAdvanced.setLayoutData((Object)gdLBLDummyAdvanced);
        this.btnAdvanced = new Button((Composite)this, 16);
        GridData gdBTNAdvanced = new GridData(768);
        gdBTNAdvanced.horizontalSpan = 2;
        this.btnAdvanced.setLayoutData((Object)gdBTNAdvanced);
        this.btnAdvanced.setText(Messages.getString("FormatSpecifierComposite.Lbl.Advanced"));
        this.btnAdvanced.addSelectionListener((SelectionListener)this);
        this.cmpAdvancedDetails = new Composite((Composite)this, 0);
        GridData gdCMPAdvancedDetails = new GridData(1808);
        gdCMPAdvancedDetails.horizontalIndent = 16;
        gdCMPAdvancedDetails.horizontalSpan = 2;
        this.cmpAdvancedDetails.setLayoutData((Object)gdCMPAdvancedDetails);
        this.cmpAdvancedDetails.setLayout((Layout)this.slAdvancedDetails);
        this.cmpAdvancedDateDetails = new Composite(this.cmpAdvancedDetails, 0);
        GridLayout glAdvDate = new GridLayout();
        glAdvDate.verticalSpacing = 5;
        glAdvDate.marginHeight = 0;
        glAdvDate.marginWidth = 0;
        this.cmpAdvancedDateDetails.setLayout((Layout)glAdvDate);
        this.cpWrapAdvancedDate = new DateAdvancedComposite(this.cmpAdvancedDateDetails);
        this.cmpAdvancedNumberDetails = new Composite(this.cmpAdvancedDetails, 0);
        GridLayout glAdvNumber = new GridLayout();
        glAdvNumber.verticalSpacing = 5;
        glAdvNumber.marginHeight = 0;
        glAdvNumber.marginWidth = 0;
        this.cmpAdvancedNumberDetails.setLayout((Layout)glAdvNumber);
        this.cpWrapAdvancedNumber = new NumberAdvancedComposite(this.cmpAdvancedNumberDetails);
        Label lblDummyFraction = new Label((Composite)this, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.heightHint = 10;
        lblDummyFraction.setLayoutData((Object)gd);
        this.btnFraction = new Button((Composite)this, 16);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.btnFraction.setLayoutData((Object)gd);
        this.btnFraction.setText(Messages.getString("FormatSpecifierComposite.Lbl.Fraction"));
        this.btnFraction.addSelectionListener((SelectionListener)this);
        this.cmpFractionNumberDetails = new Composite((Composite)this, 0);
        gd = new GridData(1808);
        gd.horizontalIndent = 16;
        gd.horizontalSpan = 2;
        this.cmpFractionNumberDetails.setLayoutData((Object)gd);
        this.cmpFractionNumberDetails.setLayout((Layout)new FormLayout());
        this.cpWrapFractionNumber = new NumberFractionComposite(this.cmpFractionNumberDetails);
        this.populateLists();
    }

    private void populateLists() {
        this.bEnableEvents = false;
        this.cmbDataType.add(Messages.getString("FormatSpecifierComposite.Lbl.Number"));
        this.cmbDataType.add(Messages.getString("FormatSpecifierComposite.Lbl.DateTime"));
        if (this.formatspecifier == null) {
            this.cmbDataType.select(0);
            this.btnUndefined.setSelection(true);
            this.slStandardDetails.topControl = this.cmpStandardNumberDetails;
            this.slAdvancedDetails.topControl = this.cmpAdvancedNumberDetails;
        } else if (this.formatspecifier instanceof DateFormatSpecifier || this.formatspecifier instanceof JavaDateFormatSpecifier) {
            this.cmbDataType.select(1);
            if (this.formatspecifier instanceof DateFormatSpecifier) {
                this.btnStandard.setSelection(true);
            } else if (this.formatspecifier instanceof JavaDateFormatSpecifier) {
                this.btnAdvanced.setSelection(true);
            } else {
                this.btnUndefined.setSelection(true);
            }
            this.slStandardDetails.topControl = this.cmpStandardDateDetails;
            this.slAdvancedDetails.topControl = this.cmpAdvancedDateDetails;
        } else if (this.formatspecifier instanceof NumberFormatSpecifier || this.formatspecifier instanceof JavaNumberFormatSpecifier) {
            this.cmbDataType.select(0);
            if (this.formatspecifier instanceof NumberFormatSpecifier) {
                this.btnStandard.setSelection(true);
            } else if (this.formatspecifier instanceof JavaNumberFormatSpecifier) {
                this.btnAdvanced.setSelection(true);
            } else {
                this.btnUndefined.setSelection(true);
            }
            this.slStandardDetails.topControl = this.cmpStandardNumberDetails;
            this.slAdvancedDetails.topControl = this.cmpAdvancedNumberDetails;
        } else if (this.formatspecifier instanceof FractionNumberFormatSpecifier) {
            this.cmbDataType.select(0);
            this.btnFraction.setSelection(true);
            this.slStandardDetails.topControl = this.cmpStandardNumberDetails;
            this.slAdvancedDetails.topControl = this.cmpAdvancedNumberDetails;
        }
        this.updateUIState();
        this.cpWrapStandardDate.populateLists();
        this.cpWrapStandardNumber.populateLists();
        this.cpWrapAdvancedNumber.populateLists();
        this.cpWrapAdvancedDate.populateLists();
        this.cpWrapFractionNumber.populateLists();
        this.layout();
        this.bEnableEvents = true;
    }

    public FormatSpecifier getFormatSpecifier() {
        if (this.btnUndefined.getSelection()) {
            return null;
        }
        this.formatspecifier = this.buildFormatSpecifier();
        return this.formatspecifier;
    }

    private FormatSpecifier buildFormatSpecifier() {
        FormatSpecifier fs = null;
        if (this.cmbDataType.getSelectionIndex() == 1) {
            if (this.btnAdvanced.getSelection()) {
                fs = this.cpWrapAdvancedDate.buildFormatSpecifier();
            } else if (this.btnStandard.getSelection()) {
                fs = this.cpWrapStandardDate.buildFormatSpecifier();
            }
        } else if (this.btnAdvanced.getSelection()) {
            fs = this.cpWrapAdvancedNumber.buildFormatSpecifier();
        } else if (this.btnStandard.getSelection()) {
            fs = this.cpWrapStandardNumber.buildFormatSpecifier();
        } else if (this.btnFraction.getSelection()) {
            fs = this.cpWrapFractionNumber.buildFormatSpecifier();
        }
        return fs;
    }

    private void updateUIState() {
        if (this.cmbDataType.getSelectionIndex() == 0) {
            if (this.btnStandard.getSelection()) {
                this.cpWrapStandardNumber.setEnabled(true);
                this.cpWrapAdvancedNumber.setEnabled(false);
                this.cpWrapFractionNumber.setEnabled(false);
            } else if (this.btnAdvanced.getSelection()) {
                this.cpWrapStandardNumber.setEnabled(false);
                this.cpWrapAdvancedNumber.setEnabled(true);
                this.cpWrapFractionNumber.setEnabled(false);
            } else if (this.btnFraction.getSelection()) {
                this.cpWrapStandardNumber.setEnabled(false);
                this.cpWrapAdvancedNumber.setEnabled(false);
                this.cpWrapFractionNumber.setEnabled(true);
            } else {
                this.cpWrapStandardNumber.setEnabled(false);
                this.cpWrapAdvancedNumber.setEnabled(false);
                this.cpWrapFractionNumber.setEnabled(false);
            }
            this.cmpFractionNumberDetails.setVisible(true);
            this.btnFraction.setVisible(true);
        } else {
            if (this.btnStandard.getSelection()) {
                this.cpWrapStandardDate.setEnabled(true);
                this.cpWrapAdvancedDate.setEnabled(false);
            } else if (this.btnAdvanced.getSelection()) {
                this.cpWrapStandardDate.setEnabled(false);
                this.cpWrapAdvancedDate.setEnabled(true);
            } else {
                this.cpWrapStandardDate.setEnabled(false);
                this.cpWrapAdvancedDate.setEnabled(false);
            }
            this.cmpFractionNumberDetails.setVisible(false);
            this.btnFraction.setVisible(false);
        }
    }

    public Point getPreferredSize() {
        return new Point(200, 150);
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.bEnableEvents) {
            return;
        }
        if (e.getSource().equals(this.cmbDataType)) {
            if (this.cmbDataType.getSelectionIndex() == 0) {
                this.slStandardDetails.topControl = this.cmpStandardNumberDetails;
                this.slAdvancedDetails.topControl = this.cmpAdvancedNumberDetails;
            } else {
                this.slStandardDetails.topControl = this.cmpStandardDateDetails;
                this.slAdvancedDetails.topControl = this.cmpAdvancedDateDetails;
                if (this.btnFraction.getSelection()) {
                    this.btnUndefined.setSelection(true);
                    this.btnFraction.setSelection(false);
                }
            }
            this.updateUIState();
            this.cmpStandardDetails.layout();
            this.cmpAdvancedDetails.layout();
        } else if (e.getSource() instanceof Button) {
            this.updateUIState();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class NumberFractionComposite
    extends Composite
    implements IFormatSpecifierUIComponent,
    ModifyListener,
    SelectionListener {
        private transient FractionNumberFormatSpecifier dummyFs;
        private transient Button btnApproximate;
        private transient Button btnUseNumerator;
        private transient Button btnUseDenorminator;
        private transient Text txtPrefix;
        private transient Text txtSuffix;
        private transient Text txtDelimiter;
        private transient Spinner spnNumerator;
        private transient Spinner spnFractionDigits;

        private NumberFractionComposite(Composite parent) {
            super(parent, 0);
            this.dummyFs = FractionNumberFormatSpecifierImpl.create();
            this.btnApproximate = null;
            this.btnUseNumerator = null;
            this.btnUseDenorminator = null;
            this.txtPrefix = null;
            this.txtSuffix = null;
            this.txtDelimiter = null;
            this.spnNumerator = null;
            this.spnFractionDigits = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glNumberStandard = new GridLayout();
            glNumberStandard.verticalSpacing = 5;
            glNumberStandard.numColumns = 4;
            glNumberStandard.marginHeight = 2;
            glNumberStandard.marginWidth = 2;
            this.setLayout((Layout)glNumberStandard);
            new Label((Composite)this, 0).setText(Messages.getString("FormatSpecifierComposite.Lbl.Delimiter"));
            this.txtDelimiter = new Text((Composite)this, 2052);
            GridData gd = new GridData(768);
            gd.widthHint = 60;
            this.txtDelimiter.setLayoutData((Object)gd);
            String str = this.getFormatSpecifier().getDelimiter();
            if (str == null) {
                str = "";
            }
            this.txtDelimiter.setText(str);
            this.txtDelimiter.addModifyListener((ModifyListener)this);
            this.btnApproximate = new Button((Composite)this, 32);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.btnApproximate.setLayoutData((Object)gd);
            this.btnApproximate.setText(Messages.getString("FormatSpecifierComposite.Lbl.Approximate"));
            this.btnApproximate.addSelectionListener((SelectionListener)this);
            new Label((Composite)this, 0).setText(Messages.getString("FormatSpecifierComposite.Lbl.Prefix"));
            this.txtPrefix = new Text((Composite)this, 2052);
            GridData gdTXTPrefix = new GridData(768);
            gdTXTPrefix.widthHint = 60;
            this.txtPrefix.setLayoutData((Object)gdTXTPrefix);
            str = this.getFormatSpecifier().getPrefix();
            if (str == null) {
                str = "";
            }
            this.txtPrefix.setText(str);
            this.txtPrefix.addModifyListener((ModifyListener)this);
            this.btnUseNumerator = new Button((Composite)this, 16);
            this.btnUseNumerator.setText(Messages.getString("FormatSpecifierComposite.Lbl.Numerator"));
            this.btnUseNumerator.addSelectionListener((SelectionListener)this);
            this.spnNumerator = new Spinner((Composite)this, 2048);
            GridData gdTXTMultiplier = new GridData(768);
            gdTXTMultiplier.widthHint = 60;
            this.spnNumerator.setLayoutData((Object)gdTXTMultiplier);
            this.spnNumerator.setMinimum(1);
            this.spnNumerator.setSelection((int)this.getFormatSpecifier().getNumerator());
            this.spnNumerator.setToolTipText(Messages.getString("FormatSpecifierComposite.Tooltip.InputAPositiveInteger"));
            this.spnNumerator.addSelectionListener((SelectionListener)this);
            new Label((Composite)this, 0).setText(Messages.getString("FormatSpecifierComposite.Lbl.Suffix"));
            this.txtSuffix = new Text((Composite)this, 2052);
            GridData gdTXTSuffix = new GridData(768);
            gdTXTSuffix.widthHint = 60;
            this.txtSuffix.setLayoutData((Object)gdTXTSuffix);
            str = this.getFormatSpecifier().getSuffix();
            if (str == null) {
                str = "";
            }
            this.txtSuffix.setText(str);
            this.txtSuffix.addModifyListener((ModifyListener)this);
            this.btnUseDenorminator = new Button((Composite)this, 16);
            this.btnUseDenorminator.setText(Messages.getString("FormatSpecifierComposite.Lbl.MaxRecursionTimes"));
            this.btnUseDenorminator.addSelectionListener((SelectionListener)this);
            this.spnFractionDigits = new Spinner((Composite)this, 2048);
            this.spnFractionDigits.setMinimum(1);
            this.spnFractionDigits.setMaximum(8);
            GridData gdISCFractionDigits = new GridData(768);
            gdISCFractionDigits.widthHint = 60;
            this.spnFractionDigits.setLayoutData((Object)gdISCFractionDigits);
            this.spnFractionDigits.setSelection(this.getFormatSpecifier().getFractionDigits());
            this.spnFractionDigits.setToolTipText(Messages.getString("FormatSpecifierComposite.Tooltip.FractionDigits"));
            this.spnFractionDigits.addSelectionListener((SelectionListener)this);
        }

        public void modifyText(ModifyEvent e) {
            Object oSource = e.getSource();
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (oSource.equals(this.txtPrefix)) {
                this.getFormatSpecifier().setPrefix(this.txtPrefix.getText());
            } else if (oSource.equals(this.txtSuffix)) {
                this.getFormatSpecifier().setSuffix(this.txtSuffix.getText());
            } else if (oSource.equals(this.txtDelimiter)) {
                this.getFormatSpecifier().setDelimiter(this.txtDelimiter.getText());
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
        }

        public void setEnabled(boolean enabled) {
            this.btnApproximate.setSelection(!this.getFormatSpecifier().isPrecise());
            this.btnApproximate.setEnabled(enabled);
            this.txtDelimiter.setEnabled(enabled);
            this.txtPrefix.setEnabled(enabled);
            this.txtSuffix.setEnabled(enabled);
            this.btnUseNumerator.setEnabled(enabled && this.btnApproximate.getSelection());
            this.btnUseDenorminator.setEnabled(enabled && this.btnApproximate.getSelection());
            if (this.getFormatSpecifier().getNumerator() > 0.0) {
                this.btnUseNumerator.setSelection(true);
                this.btnUseDenorminator.setSelection(false);
            } else {
                this.btnUseNumerator.setSelection(false);
                this.btnUseDenorminator.setSelection(true);
            }
            this.spnNumerator.setEnabled(enabled && this.btnApproximate.getSelection() && this.btnUseNumerator.getSelection());
            this.spnFractionDigits.setEnabled(enabled && this.btnApproximate.getSelection() && this.btnUseDenorminator.getSelection());
            super.setEnabled(enabled);
        }

        public void populateLists() {
            if (FormatSpecifierComposite.this.formatspecifier instanceof FractionNumberFormatSpecifier) {
                this.setEnabled(true);
            }
        }

        private FractionNumberFormatSpecifier getFormatSpecifier() {
            return FormatSpecifierComposite.this.formatspecifier instanceof FractionNumberFormatSpecifier ? (FractionNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier : this.dummyFs;
        }

        public FormatSpecifier buildFormatSpecifier() {
            FractionNumberFormatSpecifier fs = FractionNumberFormatSpecifierImpl.create();
            fs.setPrecise(!this.btnApproximate.getSelection());
            fs.setDelimiter(this.txtDelimiter.getText());
            fs.setPrefix(this.txtPrefix.getText());
            fs.setSuffix(this.txtSuffix.getText());
            fs.setFractionDigits(this.spnFractionDigits.getSelection());
            if (this.btnUseNumerator.getSelection()) {
                fs.setNumerator((double)this.spnNumerator.getSelection());
            } else {
                fs.setNumerator(0.0);
            }
            return fs;
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(this.btnApproximate)) {
                this.getFormatSpecifier().setPrecise(!this.btnApproximate.getSelection());
                this.setEnabled(true);
            } else if (e.widget.equals(this.btnUseNumerator)) {
                this.spnNumerator.setEnabled(true);
                this.spnFractionDigits.setEnabled(false);
            } else if (e.widget.equals(this.btnUseDenorminator)) {
                this.spnNumerator.setEnabled(false);
                this.spnFractionDigits.setEnabled(true);
            } else if (e.widget.equals(this.spnFractionDigits)) {
                this.getFormatSpecifier().setFractionDigits(this.spnFractionDigits.getSelection());
            } else if (e.widget.equals(this.spnNumerator)) {
                this.getFormatSpecifier().setNumerator((double)this.spnNumerator.getSelection());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class DateAdvancedComposite
    extends Composite
    implements IFormatSpecifierUIComponent,
    ModifyListener {
        private transient Text txtDatePattern;

        private DateAdvancedComposite(Composite parent) {
            super(parent, 0);
            this.txtDatePattern = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glDateAdvanced = new GridLayout();
            glDateAdvanced.verticalSpacing = 5;
            glDateAdvanced.numColumns = 2;
            glDateAdvanced.marginHeight = 2;
            glDateAdvanced.marginWidth = 2;
            GridData gdGRPDateAdvanced = new GridData(1808);
            this.setLayoutData(gdGRPDateAdvanced);
            this.setLayout((Layout)glDateAdvanced);
            Label lblDatePattern = new Label((Composite)this, 0);
            GridData gdLBLDatePattern = new GridData();
            lblDatePattern.setLayoutData((Object)gdLBLDatePattern);
            lblDatePattern.setText(Messages.getString("FormatSpecifierComposite.Lbl.DatePattern"));
            this.txtDatePattern = new Text((Composite)this, 2052);
            GridData gdTXTDatePattern = new GridData(768);
            this.txtDatePattern.setLayoutData((Object)gdTXTDatePattern);
            this.txtDatePattern.addModifyListener((ModifyListener)this);
        }

        public void populateLists() {
            String str = "";
            if (FormatSpecifierComposite.this.formatspecifier instanceof JavaDateFormatSpecifier) {
                str = ((JavaDateFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getPattern();
                if (str == null) {
                    str = "";
                }
                this.txtDatePattern.setText(str);
            }
        }

        public FormatSpecifier buildFormatSpecifier() {
            JavaDateFormatSpecifier fs = JavaDateFormatSpecifierImpl.create((String)this.txtDatePattern.getText());
            return fs;
        }

        public void setEnabled(boolean enabled) {
            this.txtDatePattern.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public void modifyText(ModifyEvent e) {
            Object oSource = e.getSource();
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (oSource.equals(this.txtDatePattern)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof JavaDateFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)JavaDateFormatSpecifierImpl.create((String)"");
                }
                ((JavaDateFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPattern(this.txtDatePattern.getText());
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
        }
    }

    private class NumberAdvancedComposite
    extends Composite
    implements IFormatSpecifierUIComponent,
    ModifyListener {
        private transient Text txtNumberPattern;
        private transient LocalizedNumberEditorComposite txtAdvMultiplier;

        private NumberAdvancedComposite(Composite parent) {
            super(parent, 0);
            this.txtNumberPattern = null;
            this.txtAdvMultiplier = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glNumberAdvanced = new GridLayout();
            glNumberAdvanced.verticalSpacing = 5;
            glNumberAdvanced.numColumns = 2;
            glNumberAdvanced.marginHeight = 2;
            glNumberAdvanced.marginWidth = 2;
            GridData gdGRPNumberAdvanced = new GridData(1808);
            this.setLayoutData(gdGRPNumberAdvanced);
            this.setLayout((Layout)glNumberAdvanced);
            Label lblAdvMultiplier = new Label((Composite)this, 0);
            GridData gdLBLAdvMultiplier = new GridData();
            lblAdvMultiplier.setLayoutData((Object)gdLBLAdvMultiplier);
            lblAdvMultiplier.setText(Messages.getString("FormatSpecifierComposite.Lbl.Multiplier"));
            this.txtAdvMultiplier = new LocalizedNumberEditorComposite(this, 2052);
            GridData gdTXTAdvMultiplier = new GridData(768);
            this.txtAdvMultiplier.setLayoutData(gdTXTAdvMultiplier);
            this.txtAdvMultiplier.addModifyListener(this);
            Label lblNumberPattern = new Label((Composite)this, 0);
            GridData gdLBLNumberPattern = new GridData();
            lblNumberPattern.setLayoutData((Object)gdLBLNumberPattern);
            lblNumberPattern.setText(Messages.getString("FormatSpecifierComposite.Lbl.NumberPattern"));
            this.txtNumberPattern = new Text((Composite)this, 2052);
            GridData gdTXTNumberPattern = new GridData(768);
            this.txtNumberPattern.setLayoutData((Object)gdTXTNumberPattern);
            this.txtNumberPattern.addModifyListener((ModifyListener)this);
        }

        public void populateLists() {
            if (FormatSpecifierComposite.this.formatspecifier instanceof JavaNumberFormatSpecifier) {
                String str;
                if (((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eIsSet((EStructuralFeature)AttributePackage.eINSTANCE.getJavaNumberFormatSpecifier_Multiplier())) {
                    this.txtAdvMultiplier.setValue(((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getMultiplier());
                }
                if ((str = ((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getPattern()) == null) {
                    str = "";
                }
                this.txtNumberPattern.setText(str);
            }
        }

        public FormatSpecifier buildFormatSpecifier() {
            JavaNumberFormatSpecifier fs = JavaNumberFormatSpecifierImpl.create((String)this.txtNumberPattern.getText());
            if (this.txtAdvMultiplier.isSetValue()) {
                ((JavaNumberFormatSpecifierImpl)fs).setMultiplier(this.txtAdvMultiplier.getValue());
            }
            return fs;
        }

        public void setEnabled(boolean enabled) {
            this.txtAdvMultiplier.setEnabled(enabled);
            this.txtNumberPattern.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public void modifyText(ModifyEvent e) {
            Object oSource = e.getSource();
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (oSource.equals((Object)this.txtAdvMultiplier)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof JavaNumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)this.txtNumberPattern.getText());
                }
                if (this.txtAdvMultiplier.isSetValue()) {
                    ((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtAdvMultiplier.getValue());
                } else {
                    ((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getJavaNumberFormatSpecifier_Multiplier());
                }
            } else if (oSource.equals(this.txtNumberPattern)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof JavaNumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"");
                }
                ((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPattern(this.txtNumberPattern.getText());
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
        }
    }

    private class DateStandardComposite
    extends Composite
    implements IFormatSpecifierUIComponent {
        private transient Combo cmbDateType;
        private transient Combo cmbDateForm;

        private DateStandardComposite(Composite parent) {
            super(parent, 0);
            this.cmbDateType = null;
            this.cmbDateForm = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glDateStandard = new GridLayout();
            glDateStandard.verticalSpacing = 5;
            glDateStandard.numColumns = 2;
            glDateStandard.marginHeight = 2;
            glDateStandard.marginWidth = 2;
            GridData gdGRPDateStandard = new GridData(1808);
            this.setLayoutData(gdGRPDateStandard);
            this.setLayout((Layout)glDateStandard);
            Label lblDateType = new Label((Composite)this, 0);
            GridData gdLBLDateType = new GridData();
            lblDateType.setLayoutData((Object)gdLBLDateType);
            lblDateType.setText(Messages.getString("FormatSpecifierComposite.Lbl.Type"));
            this.cmbDateType = new Combo((Composite)this, 12);
            GridData gdCMBDateType = new GridData(768);
            this.cmbDateType.setLayoutData((Object)gdCMBDateType);
            Label lblDateDetails = new Label((Composite)this, 0);
            GridData gdLBLDateDetails = new GridData();
            lblDateDetails.setLayoutData((Object)gdLBLDateDetails);
            lblDateDetails.setText(Messages.getString("FormatSpecifierComposite.Lbl.Details"));
            this.cmbDateForm = new Combo((Composite)this, 12);
            GridData gdCMBDateForm = new GridData(768);
            this.cmbDateForm.setLayoutData((Object)gdCMBDateForm);
        }

        public void populateLists() {
            NameSet ns = LiteralHelper.dateFormatTypeSet;
            this.cmbDateType.setItems(ns.getDisplayNames());
            if (FormatSpecifierComposite.this.formatspecifier instanceof DateFormatSpecifier) {
                this.cmbDateType.select(ns.getSafeNameIndex(((DateFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getType().getName()));
            }
            if (this.cmbDateType.getSelectionIndex() == -1) {
                this.cmbDateType.select(0);
            }
            ns = LiteralHelper.dateFormatDetailSet;
            this.cmbDateForm.setItems(ns.getDisplayNames());
            if (FormatSpecifierComposite.this.formatspecifier instanceof DateFormatSpecifier) {
                this.cmbDateForm.select(ns.getSafeNameIndex(((DateFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getDetail().getName()));
            }
            if (this.cmbDateForm.getSelectionIndex() == -1) {
                this.cmbDateForm.select(0);
            }
        }

        public FormatSpecifier buildFormatSpecifier() {
            DateFormatSpecifier fs = AttributeFactory.eINSTANCE.createDateFormatSpecifier();
            fs.setType(DateFormatType.getByName((String)LiteralHelper.dateFormatTypeSet.getNameByDisplayName(this.cmbDateType.getText())));
            fs.setDetail(DateFormatDetail.getByName((String)LiteralHelper.dateFormatDetailSet.getNameByDisplayName(this.cmbDateForm.getText())));
            return fs;
        }

        public void setEnabled(boolean enabled) {
            this.cmbDateForm.setEnabled(enabled);
            this.cmbDateType.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    }

    private class NumberStandardComposite
    extends Composite
    implements IFormatSpecifierUIComponent,
    SelectionListener,
    ModifyListener {
        private transient Text txtPrefix;
        private transient Text txtSuffix;
        private transient LocalizedNumberEditorComposite txtMultiplier;
        private transient Spinner iscFractionDigits;

        private NumberStandardComposite(Composite parent) {
            super(parent, 0);
            this.txtPrefix = null;
            this.txtSuffix = null;
            this.txtMultiplier = null;
            this.iscFractionDigits = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glNumberStandard = new GridLayout();
            glNumberStandard.verticalSpacing = 5;
            glNumberStandard.numColumns = 4;
            glNumberStandard.marginHeight = 2;
            glNumberStandard.marginWidth = 2;
            GridData gdGRPNumberStandard = new GridData(1808);
            this.setLayoutData(gdGRPNumberStandard);
            this.setLayout((Layout)glNumberStandard);
            Label lblPrefix = new Label((Composite)this, 0);
            GridData gdLBLPrefix = new GridData();
            lblPrefix.setLayoutData((Object)gdLBLPrefix);
            lblPrefix.setText(Messages.getString("FormatSpecifierComposite.Lbl.Prefix"));
            this.txtPrefix = new Text((Composite)this, 2052);
            GridData gdTXTPrefix = new GridData(768);
            gdTXTPrefix.widthHint = 60;
            this.txtPrefix.setLayoutData((Object)gdTXTPrefix);
            this.txtPrefix.addModifyListener((ModifyListener)this);
            Label lblSuffix = new Label((Composite)this, 0);
            GridData gdLBLSuffix = new GridData();
            lblSuffix.setLayoutData((Object)gdLBLSuffix);
            lblSuffix.setText(Messages.getString("FormatSpecifierComposite.Lbl.Suffix"));
            this.txtSuffix = new Text((Composite)this, 2052);
            GridData gdTXTSuffix = new GridData(768);
            gdTXTSuffix.widthHint = 60;
            this.txtSuffix.setLayoutData((Object)gdTXTSuffix);
            this.txtSuffix.addModifyListener((ModifyListener)this);
            Label lblMultiplier = new Label((Composite)this, 0);
            GridData gdLBLMultiplier = new GridData();
            lblMultiplier.setLayoutData((Object)gdLBLMultiplier);
            lblMultiplier.setText(Messages.getString("FormatSpecifierComposite.Lbl.Multiplier"));
            this.txtMultiplier = new LocalizedNumberEditorComposite(this, 2052);
            GridData gdTXTMultiplier = new GridData(768);
            gdTXTMultiplier.widthHint = 60;
            this.txtMultiplier.setLayoutData(gdTXTMultiplier);
            this.txtMultiplier.addModifyListener(this);
            Label lblFractionDigit = new Label((Composite)this, 0);
            GridData gdLBLFractionDigit = new GridData();
            lblFractionDigit.setLayoutData((Object)gdLBLFractionDigit);
            lblFractionDigit.setText(Messages.getString("FormatSpecifierComposite.Lbl.FractionDigits"));
            this.iscFractionDigits = new Spinner((Composite)this, 2048);
            GridData gdISCFractionDigits = new GridData(768);
            gdISCFractionDigits.widthHint = 60;
            this.iscFractionDigits.setLayoutData((Object)gdISCFractionDigits);
            this.iscFractionDigits.setSelection(2);
            this.iscFractionDigits.addSelectionListener((SelectionListener)this);
        }

        public void modifyText(ModifyEvent e) {
            Object oSource = e.getSource();
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (oSource.equals(this.txtPrefix)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)NumberFormatSpecifierImpl.create();
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setSuffix(this.txtSuffix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setFractionDigits(this.iscFractionDigits.getSelection());
                    if (this.txtMultiplier.isSetValue()) {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtMultiplier.getValue());
                    } else {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getNumberFormatSpecifier_Multiplier());
                    }
                }
                ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPrefix(this.txtPrefix.getText());
            } else if (oSource.equals(this.txtSuffix)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)NumberFormatSpecifierImpl.create();
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPrefix(this.txtPrefix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setFractionDigits(this.iscFractionDigits.getSelection());
                    if (this.txtMultiplier.isSetValue()) {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtMultiplier.getValue());
                    } else {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getNumberFormatSpecifier_Multiplier());
                    }
                }
                ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setSuffix(this.txtSuffix.getText());
            } else if (oSource.equals((Object)this.txtMultiplier)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)NumberFormatSpecifierImpl.create();
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPrefix(this.txtPrefix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setSuffix(this.txtSuffix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setFractionDigits(this.iscFractionDigits.getSelection());
                }
                if (this.txtMultiplier.isSetValue()) {
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtMultiplier.getValue());
                } else {
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getNumberFormatSpecifier_Multiplier());
                }
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
        }

        public void setEnabled(boolean enabled) {
            this.txtPrefix.setEnabled(enabled);
            this.txtSuffix.setEnabled(enabled);
            this.txtMultiplier.setEnabled(enabled);
            this.iscFractionDigits.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public void populateLists() {
            if (FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier) {
                String str = ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getPrefix();
                if (str == null) {
                    str = "";
                }
                this.txtPrefix.setText(str);
                str = ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getSuffix();
                if (str == null) {
                    str = "";
                }
                this.txtSuffix.setText(str);
                if (((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eIsSet((EStructuralFeature)AttributePackage.eINSTANCE.getNumberFormatSpecifier_Multiplier())) {
                    this.txtMultiplier.setValue(((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getMultiplier());
                }
                this.iscFractionDigits.setSelection(((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getFractionDigits());
            }
        }

        public FormatSpecifier buildFormatSpecifier() {
            NumberFormatSpecifier fs = NumberFormatSpecifierImpl.create();
            fs.setPrefix(this.txtPrefix.getText());
            fs.setSuffix(this.txtSuffix.getText());
            fs.setFractionDigits(this.iscFractionDigits.getSelection());
            if (this.txtMultiplier.isSetValue()) {
                fs.setMultiplier(this.txtMultiplier.getValue());
            }
            return fs;
        }

        public void widgetSelected(SelectionEvent e) {
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (e.widget.equals(this.iscFractionDigits)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)NumberFormatSpecifierImpl.create();
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPrefix(this.txtPrefix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setSuffix(this.txtSuffix.getText());
                    if (this.txtMultiplier.isSetValue()) {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtMultiplier.getValue());
                    }
                }
                ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setFractionDigits(this.iscFractionDigits.getSelection());
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    static interface IFormatSpecifierUIComponent {
        public void populateLists();

        public FormatSpecifier buildFormatSpecifier();

        public void setEnabled(boolean var1);
    }
}

