/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class LineCanvas
extends Canvas
implements PaintListener,
FocusListener {
    int iLineStyle = 1;
    int iLineWidth = 1;
    boolean isFocusIn = false;

    public LineCanvas(Composite parent, int iStyle, int iLineStyle, int iLineWidth) {
        super(parent, iStyle);
        this.iLineStyle = iLineStyle;
        this.iLineWidth = iLineWidth;
        this.addPaintListener(this);
        this.addFocusListener(this);
    }

    public int getLineStyle() {
        return this.iLineStyle;
    }

    public void setLineStyle(int iLineStyle) {
        this.iLineStyle = iLineStyle;
    }

    public int getLineWidth() {
        return this.iLineWidth;
    }

    public void setLineWidth(int iLineWidth) {
        this.iLineWidth = iLineWidth;
    }

    public void paintControl(PaintEvent pe) {
        if (this.isEnabled() && this.isFocusControl()) {
            this.isFocusIn = true;
        }
        Color cForeground = null;
        Color cBackground = null;
        if (this.isEnabled()) {
            cForeground = Display.getCurrent().getSystemColor(2);
            cBackground = Display.getCurrent().getSystemColor(25);
        } else {
            cForeground = Display.getCurrent().getSystemColor(16);
            cBackground = Display.getCurrent().getSystemColor(22);
        }
        GC gc = pe.gc;
        gc.setBackground(cBackground);
        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
        if (this.isFocusIn) {
            gc.setBackground(Display.getCurrent().getSystemColor(26));
            gc.fillRectangle(1, 1, this.getSize().x - 3, this.getSize().y - 3);
        }
        gc.setForeground(cForeground);
        gc.setLineStyle(this.iLineStyle);
        gc.setLineWidth(this.iLineWidth);
        gc.drawLine(10, this.getSize().y / 2, this.getSize().x - 10, this.getSize().y / 2);
        if (this.isFocusIn) {
            gc.setLineStyle(3);
            gc.setLineWidth(1);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.drawRectangle(1, 1, this.getSize().x - 3, this.getSize().y - 3);
        }
    }

    public void setEnabled(boolean bState) {
        super.setEnabled(bState);
        this.redraw();
    }

    public void focusGained(FocusEvent e) {
        this.isFocusIn = true;
    }

    public void focusLost(FocusEvent e) {
        this.isFocusIn = false;
    }
}

