/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import com.ibm.icu.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextEditorComposite
extends Composite
implements ModifyListener,
FocusListener,
KeyListener {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_NUMBERIC = 1;
    public static final int TYPE_DATETIME = 2;
    private transient String sText = null;
    private transient boolean bTextModified = false;
    private transient int iStyle = 0;
    private transient Text txtValue = null;
    private transient Vector vListeners = null;
    public static final int TEXT_MODIFIED = 0;
    public static final int TEXT_FRACTION_CONVERTED = 1;
    private transient boolean bEnabled = true;
    private transient int valueType = 0;
    private transient String defaultValue = "0";

    public TextEditorComposite(Composite parent, int iStyle) {
        this(parent, iStyle, 0);
    }

    public TextEditorComposite(Composite parent, int iStyle, boolean isNumber) {
        this(parent, iStyle, isNumber ? 1 : 0);
    }

    public TextEditorComposite(Composite parent, int iStyle, int valueType) {
        super(parent, 0);
        this.iStyle = iStyle;
        this.valueType = valueType;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    private void init() {
        this.sText = "";
        this.vListeners = new Vector();
        this.setLayout((Layout)new FillLayout());
    }

    private void placeComponents() {
        this.txtValue = new Text((Composite)this, this.iStyle);
        if (this.valueType == 1) {
            this.txtValue.setToolTipText(Messages.getString("TextEditorComposite.Tooltip.EnterDecimalOrFractionValue"));
        } else if (this.valueType == 2) {
            this.txtValue.setToolTipText("MM-dd-yyyy HH:mm:ss");
        }
        this.txtValue.addModifyListener((ModifyListener)this);
        this.txtValue.addFocusListener((FocusListener)this);
        this.txtValue.addKeyListener((KeyListener)this);
    }

    public void setEnabled(boolean bState) {
        this.txtValue.setEnabled(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public void setText(String sText) {
        this.txtValue.setText(sText);
    }

    public String getText() {
        return this.txtValue.getText();
    }

    public void setToolTipText(String string) {
        this.txtValue.setToolTipText(string);
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    private void fireEvent() {
        boolean isFractionConverted = false;
        if (this.valueType == 1) {
            int iDelimiter = this.sText.indexOf(47);
            if (iDelimiter < 0) {
                iDelimiter = this.sText.indexOf(58);
            }
            if (iDelimiter > 0) {
                isFractionConverted = true;
                String numerator = this.sText.substring(0, iDelimiter);
                String denominator = this.sText.substring(iDelimiter + 1);
                try {
                    this.sText = String.valueOf(Double.parseDouble(numerator) / Double.parseDouble(denominator));
                }
                catch (NumberFormatException e) {
                    this.sText = this.defaultValue == null ? "" : this.defaultValue;
                }
                this.txtValue.setText(this.sText);
            } else {
                try {
                    ChartUIUtil.getDefaultNumberFormatInstance().parse(this.sText).doubleValue();
                }
                catch (ParseException e) {
                    this.sText = this.defaultValue == null ? "" : this.defaultValue;
                    this.txtValue.setText(this.sText);
                }
            }
        } else if (this.valueType == 2) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
            try {
                sdf.parse(this.sText);
            }
            catch (ParseException e) {
                if (this.defaultValue == null) {
                    Date today = new Date();
                    this.sText = sdf.format(today);
                } else {
                    this.sText = this.defaultValue;
                }
                this.txtValue.setText(this.sText);
            }
        }
        for (int i = 0; i < this.vListeners.size(); ++i) {
            Event e = new Event();
            e.data = this.sText;
            e.widget = this;
            e.type = 0;
            ((Listener)this.vListeners.get(i)).handleEvent(e);
            if (!isFractionConverted) continue;
            e = new Event();
            e.data = this.sText;
            e.widget = this;
            e.type = 1;
            ((Listener)this.vListeners.get(i)).handleEvent(e);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.bTextModified = true;
        this.sText = this.txtValue.getText();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.bTextModified) {
            this.fireEvent();
        }
    }

    public void keyPressed(KeyEvent e) {
        if ((e.keyCode == 13 || e.keyCode == 0x1000050) && this.bTextModified) {
            this.fireEvent();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = TextEditorComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = TextEditorComposite.this.txtValue.getCaretPosition();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = TextEditorComposite.this.toControl(new Point(e.x, e.y));
                if (TextEditorComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = TextEditorComposite.this.getBounds();
                Point pt = TextEditorComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = TextEditorComposite.this.getText();
            }
        });
    }
}

