/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import com.ibm.icu.util.StringTokenizer;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.Image;

public class LineChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Line Chart";
    private static final String STACKED_SUBTYPE_LITERAL = "Stacked";
    private static final String PERCENTSTACKED_SUBTYPE_LITERAL = "Percent Stacked";
    private static final String OVERLAY_SUBTYPE_LITERAL = "Overlay";
    public static final String CHART_TITLE = Messages.getString("LineChart.Txt.DefaultLineChartTitle");
    private static final String sStackedDescription = Messages.getString("LineChart.Txt.StackedDescription");
    private static final String sPercentStackedDescription = Messages.getString("LineChart.Txt.PercentStackedDescription");
    private static final String sOverlayDescription = Messages.getString("LineChart.Txt.OverlayDescription");
    private transient Image imgIcon = UIHelper.getImage((String)"icons/obj16/linecharticon.gif");
    private transient Image imgStacked = null;
    private transient Image imgPercentStacked = null;
    private transient Image imgSideBySide = null;
    private transient Image imgSideBySide3D = null;
    private static final String[] saDimensions = new String[]{TWO_DIMENSION_TYPE, THREE_DIMENSION_TYPE};

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return this.imgIcon;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("LineChart.Txt.HelpText"));
    }

    public Collection getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<DefaultChartSubTypeImpl> vSubTypes = new Vector<DefaultChartSubTypeImpl>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            if (orientation.equals(Orientation.VERTICAL_LITERAL)) {
                this.imgStacked = UIHelper.getImage((String)"icons/wizban/stackedlinechartimage.gif");
                this.imgPercentStacked = UIHelper.getImage((String)"icons/wizban/percentstackedlinechartimage.gif");
                this.imgSideBySide = UIHelper.getImage((String)"icons/wizban/sidebysidelinechartimage.gif");
            } else {
                this.imgStacked = UIHelper.getImage((String)"icons/wizban/horizontalstackedlinechartimage.gif");
                this.imgPercentStacked = UIHelper.getImage((String)"icons/wizban/horizontalpercentstackedlinechartimage.gif");
                this.imgSideBySide = UIHelper.getImage((String)"icons/wizban/horizontalsidebysidelinechartimage.gif");
            }
            vSubTypes.add(new DefaultChartSubTypeImpl(OVERLAY_SUBTYPE_LITERAL, this.imgSideBySide, sOverlayDescription, Messages.getString("LineChart.SubType.Overlay")));
            vSubTypes.add(new DefaultChartSubTypeImpl(STACKED_SUBTYPE_LITERAL, this.imgStacked, sStackedDescription, Messages.getString("LineChart.SubType.Stacked")));
            vSubTypes.add(new DefaultChartSubTypeImpl(PERCENTSTACKED_SUBTYPE_LITERAL, this.imgPercentStacked, sPercentStackedDescription, Messages.getString("LineChart.SubType.PercentStacked")));
        } else if (sDimension.equals(THREE_DIMENSION_TYPE) || sDimension.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            this.imgSideBySide3D = UIHelper.getImage((String)"icons/wizban/sidebysidelinechart3dimage.gif");
            vSubTypes.add(new DefaultChartSubTypeImpl(OVERLAY_SUBTYPE_LITERAL, this.imgSideBySide3D, sOverlayDescription, Messages.getString("LineChart.SubType.Overlay")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        Series valueSeries;
        SeriesDefinition sdY;
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.create();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        newChart.setOrientation(orientation);
        newChart.setDimension(ChartUIUtil.getDimensionType((String)sDimension));
        newChart.setUnits("Points");
        ((Axis)newChart.getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setType(AxisType.TEXT_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setCategoryAxis(true);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        Series categorySeries = SeriesImpl.create();
        sdX.getSeries().add((Object)categorySeries);
        sdX.getSeriesPalette().update(0);
        ((Axis)newChart.getAxes().get(0)).getSeriesDefinitions().add((Object)sdX);
        newChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        if (sSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().update(0);
            valueSeries = LineSeriesImpl.create();
            valueSeries.getLabel().setVisible(true);
            ((Marker)((LineSeries)valueSeries).getMarkers().get(0)).setVisible(true);
            ((LineSeries)valueSeries).setStacked(true);
            ((LineSeries)valueSeries).setPaletteLineColor(true);
            sdY.getSeries().add((Object)valueSeries);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        } else if (sSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setPercent(true);
            sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().update(0);
            valueSeries = LineSeriesImpl.create();
            valueSeries.getLabel().setVisible(true);
            ((Marker)((LineSeries)valueSeries).getMarkers().get(0)).setVisible(true);
            ((LineSeries)valueSeries).setStacked(true);
            ((LineSeries)valueSeries).setPaletteLineColor(true);
            sdY.getSeries().add((Object)valueSeries);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        } else if (sSubType.equalsIgnoreCase(OVERLAY_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().update(0);
            valueSeries = LineSeriesImpl.create();
            valueSeries.getLabel().setVisible(true);
            ((Marker)((LineSeries)valueSeries).getMarkers().get(0)).setVisible(true);
            ((LineSeries)valueSeries).setStacked(false);
            ((LineSeries)valueSeries).setPaletteLineColor(true);
            sdY.getSeries().add((Object)valueSeries);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        }
        if (sDimension.equals(THREE_DIMENSION_TYPE)) {
            newChart.setRotation(Rotation3DImpl.create((Angle3D[])new Angle3D[]{Angle3DImpl.create((double)-20.0, (double)45.0, (double)0.0)}));
            newChart.setUnitSpacing(50.0);
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.create((int)3);
            zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
            zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
            zAxisAncillary.getTitle().setVisible(true);
            zAxisAncillary.setPrimaryAxis(true);
            zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
            zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
            zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            zAxisAncillary.getTitle().setVisible(false);
            zAxisAncillary.setType(AxisType.TEXT_LITERAL);
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            newChart.getPrimaryOrthogonalAxis(newChart.getPrimaryBaseAxes()[0]).getTitle().getCaption().getFont().setRotation(0.0);
            SeriesDefinition sdZ = SeriesDefinitionImpl.create();
            sdZ.getSeriesPalette().update(0);
            sdZ.getSeries().add((Object)SeriesImpl.create());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
        }
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("A, B, C");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5,-4,12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        if (newChart.getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
            sdAncillary.setDataSetRepresentation("Series 1");
            sd.getAncillarySampleData().add((Object)sdAncillary);
        }
        newChart.setSampleData(sd);
    }

    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Chart helperModel = (Chart)EcoreUtil.copy((EObject)currentChart);
        ChartDimension oldDimension = currentChart.getDimension();
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        if (currentChart instanceof ChartWithAxes) {
            int i;
            EList axes;
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                if (!currentChart.getSubType().equals(sNewSubType)) {
                    currentChart.setSubType(sNewSubType);
                    axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                    for (i = 0; i < axes.size(); ++i) {
                        if (sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                            ((Axis)axes.get(i)).setPercent(true);
                        } else {
                            ((Axis)axes.get(i)).setPercent(false);
                        }
                        EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                        for (int j = 0; j < seriesdefinitions.size(); ++j) {
                            Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                            if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                                series.setStacked(true);
                                continue;
                            }
                            series.setStacked(false);
                        }
                    }
                }
            } else if (currentChart.getType().equals("Bar Chart") || currentChart.getType().equals("Area Chart") || currentChart.getType().equals("Stock Chart") || currentChart.getType().equals("Scatter Chart")) {
                if (!currentChart.getType().equals("Bar Chart")) {
                    currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData()));
                    ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setType(AxisType.TEXT_LITERAL);
                }
                currentChart.setType(TYPE_LITERAL);
                currentChart.setSubType(sNewSubType);
                currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
                axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int seriesIndex = 0;
                for (i = 0; i < axes.size(); ++i) {
                    if (sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                        ((Axis)axes.get(i)).setPercent(true);
                    } else {
                        ((Axis)axes.get(i)).setPercent(false);
                    }
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    for (int j = 0; j < seriesdefinitions.size(); ++j) {
                        Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        series = this.getConvertedSeries(series, seriesIndex++);
                        ((LineSeries)series).setPaletteLineColor(true);
                        if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                            series.setStacked(true);
                        } else {
                            series.setStacked(false);
                        }
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                    }
                }
            } else {
                return null;
            }
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(true);
        } else {
            currentChart = ChartWithAxesImpl.create();
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
            currentChart.setDimension(ChartUIUtil.getDimensionType((String)sNewDimension));
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setType(AxisType.TEXT_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(true);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            currentChart.setBlock(helperModel.getBlock());
            currentChart.setDescription(helperModel.getDescription());
            currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            currentChart.setSampleData(helperModel.getSampleData());
            currentChart.setScript(helperModel.getScript());
            currentChart.setSeriesThickness(helperModel.getSeriesThickness());
            currentChart.setUnits(helperModel.getUnits());
            if (helperModel.getInteractivity() != null) {
                currentChart.getInteractivity().setEnable(helperModel.getInteractivity().isEnable());
                currentChart.getInteractivity().setLegendBehavior(helperModel.getInteractivity().getLegendBehavior());
            }
            if (helperModel.getType().equals("Pie Chart") || helperModel.getType().equals("Meter Chart")) {
                ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().clear();
                ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().add(((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0));
                ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().clear();
                ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().addAll((Collection)((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeriesDefinitions());
                Series series = ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries();
                ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().clear();
                ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().add((Object)series);
                EList seriesdefinitions = ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions();
                for (int j = 0; j < seriesdefinitions.size(); ++j) {
                    series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                    series = this.getConvertedSeries(series, j);
                    ((LineSeries)series).setPaletteLineColor(true);
                    if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                        series.setStacked(true);
                    } else {
                        series.setStacked(false);
                    }
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                }
            } else {
                return null;
            }
            currentChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
            currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        }
        if (currentChart instanceof ChartWithAxes && !((ChartWithAxes)currentChart).getOrientation().equals(newOrientation)) {
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
        }
        if (!currentChart.getDimension().equals(ChartUIUtil.getDimensionType((String)sNewDimension))) {
            currentChart.setDimension(ChartUIUtil.getDimensionType((String)sNewDimension));
        }
        if (sNewDimension.equals(THREE_DIMENSION_TYPE) && ChartUIUtil.getDimensionType((String)sNewDimension) != oldDimension) {
            ((ChartWithAxes)currentChart).setRotation(Rotation3DImpl.create((Angle3D[])new Angle3D[]{Angle3DImpl.create((double)-20.0, (double)45.0, (double)0.0)}));
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.create((int)3);
            zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
            zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
            zAxisAncillary.getTitle().setVisible(true);
            zAxisAncillary.setPrimaryAxis(true);
            zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
            zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
            zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            zAxisAncillary.getTitle().setVisible(false);
            zAxisAncillary.setType(AxisType.TEXT_LITERAL);
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            SeriesDefinition sdZ = SeriesDefinitionImpl.create();
            sdZ.getSeriesPalette().update(0);
            sdZ.getSeries().add((Object)SeriesImpl.create());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
            if (currentChart.getSampleData().getAncillarySampleData().isEmpty()) {
                BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
                sdAncillary.setDataSetRepresentation("Series 1");
                currentChart.getSampleData().getAncillarySampleData().add((Object)sdAncillary);
            }
            EList seriesdefinitions = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)currentChart, (int)0);
            for (int j = 0; j < seriesdefinitions.size(); ++j) {
                Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series.setStacked(false);
            }
        }
        return currentChart;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        LineSeries lineseries = (LineSeries)ChartCacheManager.getInstance().findSeries(LineSeriesImpl.class.getName(), seriesIndex);
        if (lineseries == null) {
            lineseries = (LineSeries)LineSeriesImpl.create();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)lineseries);
        return lineseries;
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData) {
        EList bsdList = currentSampleData.getBaseSampleData();
        Vector<BaseSampleData> vNewBaseSampleData = new Vector<BaseSampleData>();
        for (int i = 0; i < bsdList.size(); ++i) {
            BaseSampleData bsd = (BaseSampleData)bsdList.get(i);
            bsd.setDataSetRepresentation(this.getConvertedBaseSampleDataRepresentation(bsd.getDataSetRepresentation()));
            vNewBaseSampleData.add(bsd);
        }
        currentSampleData.getBaseSampleData().clear();
        currentSampleData.getBaseSampleData().addAll(vNewBaseSampleData);
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        for (int i = 0; i < osdList.size(); ++i) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
            osd.setDataSetRepresentation(this.getConvertedOrthogonalSampleDataRepresentation(osd.getDataSetRepresentation()));
            vNewOrthogonalSampleData.add(osd);
        }
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll(vNewOrthogonalSampleData);
        return currentSampleData;
    }

    private String getConvertedBaseSampleDataRepresentation(String sOldRepresentation) {
        StringTokenizer strtok = new StringTokenizer(sOldRepresentation, ",");
        StringBuffer sbNewRepresentation = new StringBuffer("");
        while (strtok.hasMoreTokens()) {
            String sElement = strtok.nextToken().trim();
            if (!sElement.startsWith("'")) {
                sbNewRepresentation.append("'");
                sbNewRepresentation.append(sElement);
                sbNewRepresentation.append("'");
            } else {
                sbNewRepresentation.append(sElement);
            }
            sbNewRepresentation.append(",");
        }
        return sbNewRepresentation.toString().substring(0, sbNewRepresentation.length() - 1);
    }

    private String getConvertedOrthogonalSampleDataRepresentation(String sOldRepresentation) {
        StringTokenizer strtok = new StringTokenizer(sOldRepresentation, ",");
        StringBuffer sbNewRepresentation = new StringBuffer("");
        while (strtok.hasMoreTokens()) {
            String sElement = strtok.nextToken().trim();
            if (sElement.startsWith("H")) {
                StringTokenizer strStockTokenizer = new StringTokenizer(sElement);
                sbNewRepresentation.append(strStockTokenizer.nextToken().trim().substring(1));
            } else {
                sbNewRepresentation.append(sElement);
            }
            sbNewRepresentation.append(",");
        }
        return sbNewRepresentation.toString().substring(0, sbNewRepresentation.length() - 1);
    }

    public String[] getSupportedDimensions() {
        return saDimensions;
    }

    public String getDefaultDimension() {
        return saDimensions[0];
    }

    public boolean supportsTransposition() {
        return true;
    }

    public boolean supportsTransposition(String dimension) {
        if (ChartUIUtil.getDimensionType((String)dimension) == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            return false;
        }
        return this.supportsTransposition();
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString("LineChart.Txt.DisplayName");
    }
}

