/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.StringTokenizer;
import java.text.ParseException;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.Image;

public class ScatterChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Scatter Chart";
    private static final String STANDARD_SUBTYPE_LITERAL = "Standard Scatter Chart";
    public static final String CHART_TITLE = Messages.getString("ScatterChart.Txt.DefaultScatterChartTitle");
    private static final String sStandardDescription = Messages.getString("ScatterChart.Txt.Description");
    private transient Image imgIcon = UIHelper.getImage((String)"icons/obj16/scattercharticon.gif");
    private transient Image img2D = null;
    private static final String[] saDimensions = new String[]{TWO_DIMENSION_TYPE};

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return this.imgIcon;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("ScatterChart.Txt.HelpText"));
    }

    public Collection getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<DefaultChartSubTypeImpl> vSubTypes = new Vector<DefaultChartSubTypeImpl>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            this.img2D = orientation.equals(Orientation.VERTICAL_LITERAL) ? UIHelper.getImage((String)"icons/wizban/scatterchartimage.gif") : UIHelper.getImage((String)"icons/wizban/horizontalscatterchartimage.gif");
            vSubTypes.add(new DefaultChartSubTypeImpl(STANDARD_SUBTYPE_LITERAL, this.img2D, sStandardDescription, Messages.getString("ScatterChart.SubType.Standard")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.create();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        newChart.setOrientation(orientation);
        newChart.setDimension(this.getDimensionFor(sDimension));
        newChart.setUnits("Points");
        ((Axis)newChart.getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setCategoryAxis(false);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        Series baseSeries = SeriesImpl.create();
        sdX.getSeries().add((Object)baseSeries);
        sdX.getSeriesPalette().update(0);
        ((Axis)newChart.getAxes().get(0)).getSeriesDefinitions().add((Object)sdX);
        newChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().update(0);
        Series orthogonalSeries = ScatterSeriesImpl.create();
        orthogonalSeries.getLabel().setVisible(true);
        ((ScatterSeries)orthogonalSeries).setStacked(false);
        sdY.getSeries().add((Object)orthogonalSeries);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        if (sSubType.equalsIgnoreCase(STANDARD_SUBTYPE_LITERAL)) {
            newChart.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        }
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("3,9,-2");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("15,-4,12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        newChart.setSampleData(sd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Chart helperModel = (Chart)EcoreUtil.copy((EObject)currentChart);
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        if (currentChart instanceof ChartWithAxes) {
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                if (!currentChart.getSubType().equals(sNewSubType)) {
                    currentChart.setSubType(sNewSubType);
                    EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                    for (int i = 0; i < axes.size(); ++i) {
                        ((Axis)axes.get(i)).setPercent(false);
                        EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                        for (int j = 0; j < seriesdefinitions.size(); ++j) {
                            Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                            series.setStacked(false);
                        }
                    }
                }
            } else {
                if (!currentChart.getType().equals("Bar Chart") && !currentChart.getType().equals("Stock Chart") && !currentChart.getType().equals("Area Chart") && !currentChart.getType().equals("Line Chart")) return null;
                currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), currentChart.getType().equals("Stock Chart")));
                currentChart.setType(TYPE_LITERAL);
                ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
                ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(false);
                currentChart.setSubType(sNewSubType);
                currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int seriesIndex = 0;
                for (int i = 0; i < axes.size(); ++i) {
                    ((Axis)axes.get(i)).setPercent(false);
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    for (int j = 0; j < seriesdefinitions.size(); ++j) {
                        Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        series = this.getConvertedSeries(series, seriesIndex++);
                        series.setStacked(false);
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                    }
                }
                ((ChartWithAxes)currentChart).setOrientation(newOrientation);
                currentChart.setDimension(this.getDimensionFor(sNewDimension));
            }
        } else {
            currentChart = ChartWithAxesImpl.create();
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
            currentChart.setDimension(this.getDimensionFor(sNewDimension));
            if (helperModel.getInteractivity() != null) {
                currentChart.getInteractivity().setEnable(helperModel.getInteractivity().isEnable());
                currentChart.getInteractivity().setLegendBehavior(helperModel.getInteractivity().getLegendBehavior());
            }
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(false);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            currentChart.setBlock(helperModel.getBlock());
            currentChart.setDescription(helperModel.getDescription());
            currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            currentChart.setSampleData(this.getConvertedSampleData(helperModel.getSampleData(), false));
            currentChart.setScript(helperModel.getScript());
            currentChart.setSeriesThickness(helperModel.getSeriesThickness());
            currentChart.setUnits(helperModel.getUnits());
            if (!helperModel.getType().equals("Pie Chart") && !helperModel.getType().equals("Meter Chart")) return null;
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().add(((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0));
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().addAll((Collection)((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeriesDefinitions());
            Series series = ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().clear();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().add((Object)series);
            EList seriesdefinitions = ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions();
            for (int j = 0; j < seriesdefinitions.size(); ++j) {
                series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series = this.getConvertedSeries(series, j);
                series.setStacked(false);
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
            }
            currentChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
            currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        }
        if (currentChart instanceof ChartWithAxes && !((ChartWithAxes)currentChart).getOrientation().equals(newOrientation)) {
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
        }
        if (currentChart.getDimension().equals(this.getDimensionFor(sNewDimension))) return currentChart;
        currentChart.setDimension(this.getDimensionFor(sNewDimension));
        return currentChart;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        ScatterSeries scatterseries = (ScatterSeries)ChartCacheManager.getInstance().findSeries(ScatterSeriesImpl.class.getName(), seriesIndex);
        if (scatterseries == null) {
            scatterseries = (ScatterSeries)ScatterSeriesImpl.create();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)scatterseries);
        return scatterseries;
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, boolean bStockSeries) {
        EList bsdList = currentSampleData.getBaseSampleData();
        Vector<BaseSampleData> vNewBaseSampleData = new Vector<BaseSampleData>();
        for (int i = 0; i < bsdList.size(); ++i) {
            BaseSampleData bsd = (BaseSampleData)bsdList.get(i);
            bsd.setDataSetRepresentation(this.getConvertedSampleDataRepresentation(bsd.getDataSetRepresentation(), false));
            vNewBaseSampleData.add(bsd);
        }
        currentSampleData.getBaseSampleData().clear();
        currentSampleData.getBaseSampleData().addAll(vNewBaseSampleData);
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        for (int i = 0; i < osdList.size(); ++i) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
            osd.setDataSetRepresentation(this.getConvertedSampleDataRepresentation(osd.getDataSetRepresentation(), bStockSeries));
            vNewOrthogonalSampleData.add(osd);
        }
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll(vNewOrthogonalSampleData);
        return currentSampleData;
    }

    private String getConvertedSampleDataRepresentation(String sOldRepresentation, boolean bStockSeries) {
        StringTokenizer strtok = new StringTokenizer(sOldRepresentation, ",");
        NumberFormat nf = NumberFormat.getNumberInstance();
        StringBuffer sbNewRepresentation = new StringBuffer("");
        int iValueCount = 0;
        while (strtok.hasMoreTokens()) {
            String sElement = strtok.nextToken().trim();
            if (sElement.startsWith("'")) {
                sElement = sElement.substring(1, sElement.length() - 1);
            }
            if (bStockSeries) {
                StringTokenizer strStockTokenizer = new StringTokenizer(sElement);
                sElement = strStockTokenizer.nextToken().trim().substring(1);
            }
            try {
                double dbl = nf.parse(sElement).doubleValue();
                sElement = String.valueOf(dbl);
            }
            catch (ParseException e) {
                sElement = String.valueOf(6.0 + (double)iValueCount);
                ++iValueCount;
            }
            sbNewRepresentation.append(sElement);
            sbNewRepresentation.append(",");
        }
        return sbNewRepresentation.toString().substring(0, sbNewRepresentation.length() - 1);
    }

    public String[] getSupportedDimensions() {
        return saDimensions;
    }

    public String getDefaultDimension() {
        return saDimensions[0];
    }

    public boolean supportsTransposition() {
        return true;
    }

    private ChartDimension getDimensionFor(String sDimension) {
        return ChartDimension.TWO_DIMENSIONAL_LITERAL;
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString("ScatterChart.Txt.DisplayName");
    }
}

