/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class AxisScaleSheet
extends AbstractPopupSheet
implements Listener,
SelectionListener {
    private static final SimpleDateFormat _sdf = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    private transient Composite cmpContent;
    private transient Label lblMin = null;
    private transient TextEditorComposite txtScaleMin = null;
    private transient Label lblMax = null;
    private transient TextEditorComposite txtScaleMax = null;
    private transient Label lblStep = null;
    private transient TextEditorComposite txtScaleStep = null;
    private transient Axis axis;

    public AxisScaleSheet(String title, ChartWizardContext context, Axis axis) {
        super(title, context, true);
        this.axis = axis;
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Scale_ID");
        GridLayout glContent = new GridLayout(2, true);
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        glContent.horizontalSpacing = 2;
        glContent.verticalSpacing = 5;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        Group grpScale = new Group(this.cmpContent, 0);
        GridData gdGRPScale = new GridData(1808);
        gdGRPScale.horizontalSpan = 4;
        grpScale.setLayoutData((Object)gdGRPScale);
        GridLayout glScale = new GridLayout();
        glScale.numColumns = 4;
        glScale.horizontalSpacing = 5;
        glScale.verticalSpacing = 5;
        glScale.marginHeight = 2;
        glScale.marginWidth = 7;
        grpScale.setLayout((Layout)glScale);
        grpScale.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Scale"));
        this.lblMin = new Label((Composite)grpScale, 0);
        GridData gdLBLMin = new GridData();
        this.lblMin.setLayoutData((Object)gdLBLMin);
        this.lblMin.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Minimum"));
        this.txtScaleMin = new TextEditorComposite((Composite)grpScale, 2052, this.getValueType());
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        this.txtScaleMin.setLayoutData(gd);
        this.txtScaleMin.setText(this.getValue(this.getAxisForProcessing().getScale().getMin()));
        this.txtScaleMin.addListener(this);
        this.txtScaleMin.setDefaultValue("");
        this.lblMax = new Label((Composite)grpScale, 0);
        this.lblMax.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Maximum"));
        this.txtScaleMax = new TextEditorComposite((Composite)grpScale, 2052, this.getValueType());
        gd = new GridData(768);
        gd.widthHint = 100;
        this.txtScaleMax.setLayoutData(gd);
        this.txtScaleMax.setText(this.getValue(this.getAxisForProcessing().getScale().getMax()));
        this.txtScaleMax.addListener(this);
        this.txtScaleMax.setDefaultValue("");
        boolean bDateTimeAxisType = this.getAxisForProcessing().getType().equals(AxisType.DATE_TIME_LITERAL);
        this.lblStep = new Label((Composite)grpScale, 0);
        this.lblStep.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Step"));
        this.lblStep.setEnabled(!bDateTimeAxisType);
        this.txtScaleStep = new TextEditorComposite((Composite)grpScale, 2052, 1);
        GridData gd2 = new GridData(768);
        gd2.widthHint = 100;
        this.txtScaleStep.setLayoutData(gd2);
        String str = "";
        if (this.getAxisForProcessing().getScale().eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Step())) {
            str = String.valueOf(this.getAxisForProcessing().getScale().getStep());
        }
        this.txtScaleStep.setText(str);
        this.txtScaleStep.addListener(this);
        this.txtScaleStep.setEnabled(!bDateTimeAxisType);
        this.txtScaleStep.setDefaultValue("");
        GridLayout glGridCount = new GridLayout();
        glGridCount.numColumns = 2;
        glGridCount.horizontalSpacing = 5;
        glGridCount.marginHeight = 0;
        glGridCount.marginWidth = 0;
        this.populateLists();
        return this.cmpContent;
    }

    private void populateLists() {
        this.setState(this.getAxisForProcessing().getType().getName());
    }

    private int getValueType() {
        if (this.getAxisForProcessing().getType() == AxisType.TEXT_LITERAL) {
            return 0;
        }
        if (this.getAxisForProcessing().getType() == AxisType.DATE_TIME_LITERAL) {
            return 2;
        }
        return 1;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtScaleMin)) {
            if (this.txtScaleMin.getText().length() == 0) {
                this.getAxisForProcessing().getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Min());
            } else {
                DataElement de = this.getTypedDataElement(this.txtScaleMin.getText());
                if (de != null) {
                    this.getAxisForProcessing().getScale().setMin(de);
                }
            }
        } else if (event.widget.equals((Object)this.txtScaleMax)) {
            if (this.txtScaleMax.getText().length() == 0) {
                this.getAxisForProcessing().getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Max());
            } else {
                DataElement de = this.getTypedDataElement(this.txtScaleMax.getText());
                if (de != null) {
                    this.getAxisForProcessing().getScale().setMax(de);
                }
            }
        } else if (event.widget.equals((Object)this.txtScaleStep)) {
            try {
                if (this.txtScaleStep.getText().length() == 0) {
                    this.getAxisForProcessing().getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Step());
                } else {
                    double dbl = Double.valueOf(this.txtScaleStep.getText());
                    if (dbl == 0.0) {
                        this.getAxisForProcessing().getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Step());
                    } else {
                        this.getAxisForProcessing().getScale().setStep(dbl);
                    }
                }
            }
            catch (NumberFormatException e1) {
                this.txtScaleStep.setText(String.valueOf(this.getAxisForProcessing().getScale().getStep()));
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    private void setState(String sType) {
        boolean bEnabled = !this.getAxisForProcessing().isCategoryAxis() && !sType.equals(AxisType.TEXT_LITERAL.getName());
        this.lblMin.setEnabled(bEnabled);
        this.txtScaleMin.setEnabled(bEnabled);
        this.lblMax.setEnabled(bEnabled);
        this.txtScaleMax.setEnabled(bEnabled);
        this.lblStep.setEnabled(bEnabled);
        this.txtScaleStep.setEnabled(bEnabled);
        this.lblStep.setEnabled(bEnabled && !sType.equals(AxisType.DATE_TIME_LITERAL.getName()));
        this.txtScaleStep.setEnabled(bEnabled && !sType.equals(AxisType.DATE_TIME_LITERAL.getName()));
    }

    private String getValue(DataElement de) {
        if (de instanceof DateTimeDataElement) {
            Date dt = ((DateTimeDataElement)de).getValueAsCalendar().getTime();
            return _sdf.format(dt);
        }
        if (de instanceof NumberDataElement) {
            return ChartUIUtil.getDefaultNumberFormatInstance().format(((NumberDataElement)de).getValue());
        }
        return "";
    }

    private DataElement getTypedDataElement(String strDataElement) {
        NumberFormat nf = ChartUIUtil.getDefaultNumberFormatInstance();
        try {
            Date dateElement = _sdf.parse(strDataElement);
            Calendar cal = Calendar.getInstance((TimeZone)TimeZone.getDefault());
            cal.setTime(dateElement);
            return DateTimeDataElementImpl.create((Calendar)cal);
        }
        catch (ParseException e) {
            try {
                Number numberElement = nf.parse(strDataElement);
                return NumberDataElementImpl.create((double)numberElement.doubleValue());
            }
            catch (ParseException e1) {
                return null;
            }
        }
    }

    private Axis getAxisForProcessing() {
        return this.axis;
    }
}

