/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.series;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IChangeWithoutNotification;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class SeriesSheetImpl
extends SubtaskSheetImpl
implements SelectionListener {
    private static Hashtable htSeriesNames = null;
    private transient Combo cmbColorBy;
    static /* synthetic */ Class class$org$eclipse$birt$chart$model$component$impl$SeriesImpl;

    public void createControl(Composite parent) {
        int i;
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartSeries_ID");
        int COLUMN_CONTENT = 4;
        this.cmpContent = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point p = super.computeSize(wHint, hHint, changed);
                p.y = 200;
                return p;
            }
        };
        GridLayout glContent = new GridLayout(4, false);
        glContent.horizontalSpacing = 10;
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        new Label(this.cmpContent, 0).setText(Messages.getString("ChartSheetImpl.Label.ColorBy"));
        this.cmbColorBy = new Combo(this.cmpContent, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.cmbColorBy.setLayoutData((Object)gridData);
        NameSet ns = LiteralHelper.legendItemTypeSet;
        this.cmbColorBy.setItems(ns.getDisplayNames());
        this.cmbColorBy.select(ns.getSafeNameIndex(this.getChart().getLegend().getItemType().getName()));
        this.cmbColorBy.addSelectionListener((SelectionListener)this);
        Label separator = new Label(this.cmpContent, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        separator.setLayoutData((Object)gd);
        int COLUMN_DETAIL = 6;
        ScrolledComposite cmpScroll = new ScrolledComposite(this.cmpContent, 512);
        GridData gd2 = new GridData(1808);
        gd2.horizontalSpan = 4;
        cmpScroll.setLayoutData((Object)gd2);
        cmpScroll.setMinHeight((ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.getChart()).size() + 1) * 24 + 40);
        cmpScroll.setExpandVertical(true);
        cmpScroll.setExpandHorizontal(true);
        Composite cmpList = new Composite((Composite)cmpScroll, 0);
        GridLayout glContent2 = new GridLayout(6, false);
        glContent2.horizontalSpacing = 10;
        cmpList.setLayout((Layout)glContent2);
        cmpScroll.setContent((Control)cmpList);
        Label lblSeries = new Label(cmpList, 0);
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 0x1000000;
        lblSeries.setLayoutData((Object)gd3);
        lblSeries.setFont(JFaceResources.getBannerFont());
        lblSeries.setText(Messages.getString("SeriesSheetImpl.Label.Series"));
        Label lblTitle = new Label(cmpList, 0);
        GridData gd4 = new GridData();
        gd4.horizontalAlignment = 0x1000000;
        lblTitle.setLayoutData((Object)gd4);
        lblTitle.setFont(JFaceResources.getBannerFont());
        lblTitle.setText(Messages.getString("SeriesSheetImpl.Label.Title"));
        Label lblType = new Label(cmpList, 0);
        GridData gd5 = new GridData();
        gd5.horizontalAlignment = 0x1000000;
        lblType.setLayoutData((Object)gd5);
        lblType.setFont(JFaceResources.getBannerFont());
        lblType.setText(Messages.getString("SeriesSheetImpl.Label.Type"));
        Label lblVisible = new Label(cmpList, 0);
        GridData gd6 = new GridData();
        gd6.horizontalAlignment = 0x1000000;
        lblVisible.setLayoutData((Object)gd6);
        lblVisible.setFont(JFaceResources.getBannerFont());
        lblVisible.setText(Messages.getString("SeriesSheetImpl.Label.Visible"));
        Label lblStack = new Label(cmpList, 0);
        GridData gd7 = new GridData();
        gd7.horizontalAlignment = 0x1000000;
        lblStack.setLayoutData((Object)gd7);
        lblStack.setFont(JFaceResources.getBannerFont());
        lblStack.setText(Messages.getString("SeriesSheetImpl.Label.Stacked"));
        Label lblTranslucent = new Label(cmpList, 0);
        GridData gd8 = new GridData();
        gd8.horizontalAlignment = 0x1000000;
        lblTranslucent.setLayoutData((Object)gd8);
        lblTranslucent.setFont(JFaceResources.getBannerFont());
        lblTranslucent.setText(Messages.getString("SeriesSheetImpl.Label.Translucent"));
        Object seriesDefns = ChartUIUtil.getBaseSeriesDefinitions((Chart)this.getChart());
        int treeIndex = 0;
        for (i = 0; i < seriesDefns.size(); ++i) {
            new SeriesOptionChoser((SeriesDefinition)seriesDefns.get(i), this.getChart() instanceof ChartWithAxes ? Messages.getString("SeriesSheetImpl.Label.CategoryXSeries") : Messages.getString("SeriesSheetImpl.Label.CategoryBaseSeries"), i, treeIndex++).placeComponents(cmpList);
        }
        seriesDefns = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.getChart());
        for (i = 0; i < seriesDefns.size(); ++i) {
            String text = this.getChart() instanceof ChartWithAxes ? Messages.getString("SeriesSheetImpl.Label.ValueYSeries") : Messages.getString("SeriesSheetImpl.Label.ValueOrthogonalSeries");
            new SeriesOptionChoser((SeriesDefinition)seriesDefns.get(i), seriesDefns.size() == 1 ? text : text + " - " + (i + 1), i, treeIndex++).placeComponents(cmpList);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(this.cmbColorBy)) {
            this.getChart().getLegend().setItemType(LegendItemType.getByName((String)LiteralHelper.legendItemTypeSet.getNameByDisplayName(this.cmbColorBy.getText())));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class SeriesOptionChoser
    implements SelectionListener,
    Listener {
        private transient SeriesDefinition seriesDefn;
        private transient String seriesName;
        private transient Link linkSeries;
        private transient ExternalizedTextEditorComposite txtTitle;
        private transient Combo cmbTypes;
        private transient Button btnVisible;
        private transient Button btnStack;
        private transient Button btnTranslucent;
        private transient int iSeriesDefinitionIndex = 0;
        private transient int treeIndex = 0;

        public SeriesOptionChoser(SeriesDefinition seriesDefn, String seriesName, int iSeriesDefinitionIndex, int treeIndex) {
            this.seriesDefn = seriesDefn;
            this.seriesName = seriesName;
            this.iSeriesDefinitionIndex = iSeriesDefinitionIndex;
            this.treeIndex = treeIndex;
        }

        public void placeComponents(Composite parent) {
            Series series = this.seriesDefn.getDesignTimeSeries();
            this.linkSeries = new Link(parent, 0);
            this.linkSeries.setText("<a>" + this.seriesName + "</a>");
            this.linkSeries.addSelectionListener((SelectionListener)this);
            List keys = null;
            if (SeriesSheetImpl.this.getContext().getUIServiceProvider() != null) {
                keys = SeriesSheetImpl.this.getContext().getUIServiceProvider().getRegisteredKeys();
            }
            this.txtTitle = new ExternalizedTextEditorComposite(parent, 2052, -1, -1, keys, SeriesSheetImpl.this.getContext().getUIServiceProvider(), series.getSeriesIdentifier().toString());
            GridData gd = new GridData(768);
            this.txtTitle.setLayoutData(gd);
            this.txtTitle.addListener(this);
            this.cmbTypes = new Combo(parent, 12);
            gd = new GridData(768);
            this.cmbTypes.setLayoutData((Object)gd);
            this.cmbTypes.addSelectionListener((SelectionListener)this);
            if (this.iSeriesDefinitionIndex == 0) {
                this.cmbTypes.setEnabled(false);
            }
            if (!series.getClass().isAssignableFrom(class$org$eclipse$birt$chart$model$component$impl$SeriesImpl == null ? (class$org$eclipse$birt$chart$model$component$impl$SeriesImpl = SeriesSheetImpl.class$("org.eclipse.birt.chart.model.component.impl.SeriesImpl")) : class$org$eclipse$birt$chart$model$component$impl$SeriesImpl)) {
                this.btnVisible = new Button(parent, 32);
                gd = new GridData();
                gd.horizontalAlignment = 0x1000000;
                this.btnVisible.setLayoutData((Object)gd);
                this.btnVisible.setSelection(series.isVisible());
                this.btnVisible.addSelectionListener((SelectionListener)this);
                this.btnStack = new Button(parent, 32);
                gd = new GridData();
                gd.horizontalAlignment = 0x1000000;
                this.btnStack.setLayoutData((Object)gd);
                this.btnStack.setEnabled(series.canBeStacked() && SeriesSheetImpl.this.getChart().getDimension().getValue() != 2);
                this.btnStack.setSelection(series.isStacked());
                this.btnStack.addSelectionListener((SelectionListener)this);
                this.btnTranslucent = new Button(parent, 32);
                gd = new GridData();
                gd.horizontalAlignment = 0x1000000;
                this.btnTranslucent.setLayoutData((Object)gd);
                this.btnTranslucent.setSelection(series.isTranslucent());
                this.btnTranslucent.addSelectionListener((SelectionListener)this);
            } else {
                Label dummy = new Label(parent, 32);
                GridData gd2 = new GridData();
                gd2.horizontalSpan = 3;
                dummy.setLayoutData((Object)gd2);
            }
            this.populateLists(this.seriesDefn.getDesignTimeSeries());
        }

        public void widgetSelected(SelectionEvent e) {
            Series series = this.seriesDefn.getDesignTimeSeries();
            if (e.getSource().equals(this.cmbTypes)) {
                if (this.seriesDefn.getDesignTimeSeries().canParticipateInCombination()) {
                    Series newSeries = this.getNewSeries(this.cmbTypes.getText(), series);
                    newSeries.eAdapters().addAll((Collection)this.seriesDefn.eAdapters());
                    this.seriesDefn.getSeries().set(0, (Object)newSeries);
                    this.btnVisible.setSelection(newSeries.isVisible());
                    this.btnStack.setEnabled(newSeries.canBeStacked());
                    this.btnStack.setSelection(newSeries.isStacked());
                    this.btnTranslucent.setSelection(newSeries.isTranslucent());
                    this.txtTitle.setText(newSeries.getSeriesIdentifier().toString());
                }
            } else if (e.getSource().equals(this.btnVisible)) {
                series.setVisible(this.btnVisible.getSelection());
            } else if (e.getSource().equals(this.btnStack)) {
                series.setStacked(this.btnStack.getSelection());
            } else if (e.getSource().equals(this.btnTranslucent)) {
                series.setTranslucent(this.btnTranslucent.getSelection());
            } else if (e.getSource().equals(this.linkSeries)) {
                this.switchTo(this.treeIndex);
            }
        }

        private Series getNewSeries(String sSeriesName, Series oldSeries) {
            try {
                ChartCacheManager.getInstance().cacheSeries(this.iSeriesDefinitionIndex, oldSeries);
                Series series = ChartCacheManager.getInstance().findSeries((String)htSeriesNames.get(sSeriesName), this.iSeriesDefinitionIndex);
                if (series == null) {
                    Class<?> seriesClass = Class.forName((String)htSeriesNames.get(sSeriesName));
                    Method createMethod = seriesClass.getDeclaredMethod("create", new Class[0]);
                    Series newSeries = (Series)createMethod.invoke(seriesClass, new Object[0]);
                    ChartAdapter.changeChartWithoutNotification((IChangeWithoutNotification)new IChangeWithoutNotification(this, oldSeries, newSeries){
                        private final /* synthetic */ Series val$oldSeries;
                        private final /* synthetic */ Series val$newSeries;
                        private final /* synthetic */ SeriesOptionChoser this$1;
                        {
                            this.this$1 = this$1;
                            this.val$oldSeries = val$oldSeries;
                            this.val$newSeries = val$newSeries;
                        }

                        public Object run() {
                            ChartUIUtil.copyGeneralSeriesAttributes((Series)this.val$oldSeries, (Series)this.val$newSeries);
                            return null;
                        }
                    });
                    series = newSeries;
                }
                return series;
            }
            catch (Exception e) {
                WizardBase.displayException((Throwable)e);
                return null;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void handleEvent(Event event) {
            if (event.widget.equals((Object)this.txtTitle)) {
                this.seriesDefn.getDesignTimeSeries().setSeriesIdentifier((Object)this.txtTitle.getText());
            }
        }

        private void populateLists(Series series) {
            if (series.canParticipateInCombination()) {
                try {
                    this.populateSeriesTypes(PluginSettings.instance().getRegisteredSeries(), series);
                }
                catch (ChartException e) {
                    e.printStackTrace();
                }
            } else {
                String seriesName = PluginSettings.instance().getSeriesDisplayName(series.getClass().getName());
                this.cmbTypes.add(seriesName);
                this.cmbTypes.select(0);
            }
        }

        private void populateSeriesTypes(String[] allSeriesTypes, Series series) {
            for (int i = 0; i < allSeriesTypes.length; ++i) {
                try {
                    Class<?> seriesClass = Class.forName(allSeriesTypes[i]);
                    Method createMethod = seriesClass.getDeclaredMethod("create", new Class[0]);
                    Series newSeries = (Series)createMethod.invoke(seriesClass, new Object[0]);
                    if (htSeriesNames == null) {
                        htSeriesNames = new Hashtable(20);
                    }
                    String sDisplayName = PluginSettings.instance().getSeriesDisplayName(allSeriesTypes[i]);
                    htSeriesNames.put(sDisplayName, allSeriesTypes[i]);
                    if (!newSeries.canParticipateInCombination()) continue;
                    this.cmbTypes.add(sDisplayName);
                    if (!allSeriesTypes[i].equals(series.getClass().getName())) continue;
                    this.cmbTypes.select(this.cmbTypes.getItemCount() - 1);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void switchTo(int index) {
            TreeItem currentItem = SeriesSheetImpl.this.getParentTask().getNavigatorTree().getSelection()[0];
            TreeItem[] children = currentItem.getItems();
            if (index < children.length) {
                SeriesSheetImpl.this.getParentTask().switchToTreeItem(children[index]);
            }
        }
    }
}

