/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.series;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.CurveFittingImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.DialLabelSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.LineSeriesMarkerSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.PieTitleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesLabelSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesPaletteSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesRegionSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesTrendlineSheet;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SeriesYSheetImpl
extends SubtaskSheetImpl
implements Listener,
SelectionListener {
    private transient Button btnShowLine;
    private transient Button btnTrendline;
    private transient Hashtable htSeriesAttributeUIProviders = null;

    public void getComponent(Composite parent) {
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Group grpDetails = new Group(this.cmpContent, 0);
        GridData gdCMPDetails = new GridData(1808);
        gdCMPDetails.horizontalSpan = 2;
        grpDetails.setLayoutData((Object)gdCMPDetails);
        grpDetails.setLayout((Layout)new FillLayout());
        grpDetails.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.SeriesDetails"));
        Series series = this.getSeriesDefinitionForProcessing().getDesignTimeSeries();
        this.getSeriesAttributeUI(series, (Composite)grpDetails);
        if (this.isTrendlineAvailable()) {
            this.btnShowLine = new Button(this.cmpContent, 32);
            this.btnShowLine.setText(Messages.getString("SeriesYSheetImpl.Label.ShowTrendline"));
            this.btnShowLine.addSelectionListener((SelectionListener)this);
            this.btnShowLine.setSelection(this.getSeriesDefinitionForProcessing().getDesignTimeSeries().getCurveFitting() != null);
        }
        this.createButtonGroup(this.cmpContent);
    }

    private void createButtonGroup(Composite parent) {
        AbstractPopupSheet popup;
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        if (!(this.getSeriesDefinitionForProcessing().getDesignTimeSeries() instanceof StockSeries)) {
            if (this.isMeterSeries()) {
                popup = new DialLabelSheet(Messages.getString("SeriesYSheetImpl.Label.Labels"), this.getContext(), this.getSeriesDefinitionForProcessing());
                Button btnDialLabel = this.createToggleButton(cmp, Messages.getString("SeriesYSheetImpl.Label.Labels&"), popup);
                btnDialLabel.addSelectionListener((SelectionListener)this);
                popup = new SeriesRegionSheet(Messages.getString("SeriesYSheetImpl.Label.Region"), this.getContext(), this.getSeriesDefinitionForProcessing());
                Button btnDialRegion = this.createToggleButton(cmp, Messages.getString("SeriesYSheetImpl.Label.Region&"), popup);
                btnDialRegion.addSelectionListener((SelectionListener)this);
            } else {
                popup = new SeriesLabelSheet(Messages.getString("SeriesYSheetImpl.Label.Labels"), this.getContext(), this.getSeriesDefinitionForProcessing());
                Button btnLabel = this.createToggleButton(cmp, Messages.getString("SeriesYSheetImpl.Label.Labels&"), popup);
                btnLabel.addSelectionListener((SelectionListener)this);
            }
        } else {
            new Button(cmp, 0).setVisible(false);
        }
        if (this.getSeriesDefinitionForProcessing().getDesignTimeSeries() instanceof PieSeries) {
            popup = new PieTitleSheet(Messages.getString("SeriesYSheetImpl.Label.Titles"), this.getContext(), this.getSeriesDefinitionForProcessing());
            Button btnPieTitle = this.createToggleButton(cmp, Messages.getString("SeriesYSheetImpl.Label.Titles&"), popup);
            btnPieTitle.addSelectionListener((SelectionListener)this);
        }
        if (this.getSeriesDefinitionForProcessing().getDesignTimeSeries() instanceof LineSeries) {
            popup = new LineSeriesMarkerSheet(Messages.getString("SeriesYSheetImpl.Label.Markers"), this.getContext(), (LineSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries());
            Button btnLineMarker = this.createToggleButton(cmp, Messages.getString("SeriesYSheetImpl.Label.Markers&"), popup);
            btnLineMarker.addSelectionListener((SelectionListener)this);
        }
        popup = new InteractivitySheet(Messages.getString("SeriesYSheetImpl.Label.Interactivity"), this.getContext(), this.getSeriesDefinitionForProcessing().getDesignTimeSeries().getTriggers(), true, false);
        Button btnInteractivity = this.createToggleButton(cmp, Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup);
        btnInteractivity.addSelectionListener((SelectionListener)this);
        btnInteractivity.setEnabled(this.getChart().getInteractivity().isEnable());
        if (this.isTrendlineAvailable()) {
            popup = new SeriesTrendlineSheet(Messages.getString("SeriesYSheetImpl.Label.Trendline"), this.getContext(), this.getSeriesDefinitionForProcessing());
            this.btnTrendline = this.createToggleButton(cmp, Messages.getString("SeriesYSheetImpl.Label.Trendline&"), popup);
            this.btnTrendline.addSelectionListener((SelectionListener)this);
            this.btnTrendline.setEnabled(this.btnShowLine.getSelection());
        }
        popup = new SeriesPaletteSheet(Messages.getString("SeriesXSheetImpl.Label.SeriesPalette"), this.getContext(), this.getSeriesDefinitionForProcessing());
        Button btnPalette = this.createToggleButton(cmp, Messages.getString("SeriesXSheetImpl.Label.SeriesPalette&"), popup);
        btnPalette.addSelectionListener((SelectionListener)this);
    }

    private void getSeriesAttributeUI(Series series, Composite parent) {
        if (this.htSeriesAttributeUIProviders == null) {
            this.htSeriesAttributeUIProviders = new Hashtable();
            this.getSeriesAttributeUIProviders();
        }
        ((ISeriesUIProvider)this.htSeriesAttributeUIProviders.get(series.getClass().getName())).getSeriesAttributeSheet(parent, series, this.getContext());
    }

    private void getSeriesAttributeUIProviders() {
        Collection cRegisteredEntries = ChartUIExtensionsImpl.instance().getSeriesUIComponents();
        Iterator iterEntries = cRegisteredEntries.iterator();
        while (iterEntries.hasNext()) {
            ISeriesUIProvider provider = (ISeriesUIProvider)iterEntries.next();
            String sSeries = provider.getSeriesClass();
            this.htSeriesAttributeUIProviders.put(sSeries, provider);
        }
    }

    public void handleEvent(Event event) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getText());
        }
        if (e.widget.equals(this.btnShowLine)) {
            this.btnTrendline.setEnabled(this.btnShowLine.getSelection());
            if (this.btnShowLine.getSelection()) {
                CurveFitting cf = CurveFittingImpl.create();
                cf.eAdapters().addAll((Collection)this.getSeriesDefinitionForProcessing().getDesignTimeSeries().eAdapters());
                this.getSeriesDefinitionForProcessing().getDesignTimeSeries().setCurveFitting(cf);
            } else {
                this.getSeriesDefinitionForProcessing().getDesignTimeSeries().setCurveFitting(null);
                if (this.btnTrendline.getSelection()) {
                    this.btnTrendline.setSelection(false);
                    this.detachPopup((Widget)this.btnTrendline);
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private SeriesDefinition getSeriesDefinitionForProcessing() {
        SeriesDefinition sd = null;
        if (this.getChart() instanceof ChartWithAxes) {
            int iAxis = this.getParentAxisIndex(this.getIndex());
            int iAxisSeries = this.getSeriesIndexWithinAxis(this.getIndex());
            sd = (SeriesDefinition)((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(iAxis)).getSeriesDefinitions().get(iAxisSeries);
        } else if (this.getChart() instanceof ChartWithoutAxes) {
            sd = (SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.getChart()).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(this.getIndex());
        }
        return sd;
    }

    private int getParentAxisIndex(int iSeriesDefinitionIndex) {
        int iTmp = 0;
        int iAxisCount = ((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().size();
        for (int i = 0; i < iAxisCount; ++i) {
            if ((iTmp += ((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(i)).getSeriesDefinitions().size()) - 1 < iSeriesDefinitionIndex) continue;
            return i;
        }
        return 0;
    }

    private int getSeriesIndexWithinAxis(int iSeriesDefinitionIndex) {
        int iTotalDefinitions = 0;
        int iAxisCount = ((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().size();
        for (int i = 0; i < iAxisCount; ++i) {
            int iOldTotal = iTotalDefinitions;
            if ((iTotalDefinitions += ((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(i)).getSeriesDefinitions().size()) - 1 < iSeriesDefinitionIndex) continue;
            return iSeriesDefinitionIndex - iOldTotal;
        }
        return iSeriesDefinitionIndex;
    }

    private boolean isTrendlineAvailable() {
        return this.getChart() instanceof ChartWithAxes && this.getChart().getDimension() != ChartDimension.THREE_DIMENSIONAL_LITERAL;
    }

    private boolean isMeterSeries() {
        return this.getSeriesDefinitionForProcessing().getDesignTimeSeries() instanceof DialSeries;
    }
}

